/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.linting.extensions.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;

public class RawExceptionThrowCheck
extends AbstractCheck {
    static final String ERROR_MESSAGE = "Directly throwing a new exception is disallowed. Use the \"io.clientcore.core.instrumentation.logging.ClientLogger\" API instead, such as \"logger.throwableAtError()\" or \"logger.throwableAtWarning()\". See https://github.com/Azure/azure-sdk-for-java/wiki/Client-core:-logging-exceptions-best-practices for more details.";
    private static final String[] IGNORED_EXCEPTIONS = new String[]{"NullPointerException", "IllegalArgumentException", "IllegalStateException", "UnsupportedOperationException"};
    private static final String CORE_EXCEPTION_FACTORY_NAME = "CoreException.from";

    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    public int[] getRequiredTokens() {
        return new int[]{90};
    }

    public void visitToken(DetailAST token) {
        DetailAST expr = token.findFirstToken(28);
        if (expr == null) {
            return;
        }
        DetailAST newToken = expr.findFirstToken(136);
        if (newToken != null) {
            if (RawExceptionThrowCheck.isNotIgnoredException(FullIdent.createFullIdentBelow((DetailAST)newToken).getText())) {
                this.log(newToken, ERROR_MESSAGE, new Object[0]);
            }
            return;
        }
        DetailAST methodCallToken = expr.findFirstToken(27);
        if (methodCallToken != null && CORE_EXCEPTION_FACTORY_NAME.equals(FullIdent.createFullIdentBelow((DetailAST)methodCallToken).getText())) {
            this.log(methodCallToken, ERROR_MESSAGE, new Object[0]);
        }
    }

    private static boolean isNotIgnoredException(String exceptionName) {
        for (String ignoredException : IGNORED_EXCEPTIONS) {
            if (!exceptionName.endsWith(ignoredException)) continue;
            return false;
        }
        return true;
    }
}

