/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.linting.extensions.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.utils.CheckUtil;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import io.clientcore.linting.extensions.checkstyle.checks.ImplementationExcludingCheck;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NoImplInPublicAPI
extends ImplementationExcludingCheck {
    private static final String ALTERNATIVE_MOVE_TO_PUBLIC_API = "Alternatively, it can be removed from the implementation package and made public API, after appropriate API review.";
    static final String TYPE_PARAM_TYPE_ERROR = "\"%s\" is in an implementation package and should not be used as a type parameter type in public API. Alternatively, it can be removed from the implementation package and made public API, after appropriate API review.";
    static final String IMPLEMENTS_TYPE_ERROR = "\"%s\" is in an implementation package and should not be implemented by a type in public API. Alternatively, it can be removed from the implementation package and made public API, after appropriate API review.";
    static final String EXTENDS_TYPE_ERROR = "\"%s\" is in an implementation package and should not be extended by a type in public API. Alternatively, it can be removed from the implementation package and made public API, after appropriate API review.";
    static final String PARAM_TYPE_ERROR = "\"%s\" is in an implementation package and should not be used as a parameter type in public API. Alternatively, it can be removed from the implementation package and made public API, after appropriate API review.";
    static final String RETURN_TYPE_ERROR = "\"%s\" is in an implementation package and should not be a return type for public API. Alternatively, it can be removed from the implementation package and made public API, after appropriate API review.";
    private static final Pattern IMPLEMENTATION_CLASS = Pattern.compile(".*?\\.implementation.*?\\.(\\w+)");
    private final Set<String> implementationClassSet = new HashSet<String>();

    @Override
    public int[] getTokensForCheck() {
        return new int[]{30, 14, 15, 154, 9};
    }

    @Override
    public void beforeTree(DetailAST root) {
        this.implementationClassSet.clear();
    }

    @Override
    public void processToken(DetailAST ast) {
        if (ast.getType() == 30) {
            String importClassPath = FullIdent.createFullIdentBelow((DetailAST)ast).getText();
            Matcher implementationMatch = IMPLEMENTATION_CLASS.matcher(importClassPath);
            if (implementationMatch.matches()) {
                this.implementationClassSet.add(implementationMatch.group(1));
            }
        } else if (!(ast.getType() != 14 && ast.getType() != 15 || NoImplInPublicAPI.isNonPublicDefinition(ast))) {
            CheckUtil.getTypeParameters((DetailAST)ast).forEach(this::checkIfTypeParameterImplementationType);
            this.checkExtendsAndImplements(ast);
        } else if (ast.getType() == 154 && !NoImplInPublicAPI.isNonPublicDefinition(ast)) {
            this.checkExtendsAndImplements(ast);
        } else if (ast.getType() == 9 && !NoImplInPublicAPI.isInStaticInitializer(ast)) {
            Scope surroundingScope = ScopeUtil.getSurroundingScope((DetailAST)ast);
            if (surroundingScope != Scope.PUBLIC && surroundingScope != Scope.PROTECTED) {
                return;
            }
            Scope methodScope = ScopeUtil.getScopeFromMods((DetailAST)ast.findFirstToken(5));
            if (methodScope == Scope.PUBLIC || methodScope == Scope.PROTECTED) {
                DetailAST typeAST = ast.findFirstToken(13);
                String returnType = FullIdent.createFullIdentBelow((DetailAST)typeAST).getText();
                if (NoImplInPublicAPI.isImplementationType(returnType, this.implementationClassSet)) {
                    this.log(typeAST, String.format(RETURN_TYPE_ERROR, returnType), new Object[0]);
                }
                DetailAST paramAST = ast.findFirstToken(20);
                TokenUtil.forEachChild((DetailAST)paramAST, (int)21, paramDefAst -> {
                    DetailAST paramTypeAST = paramDefAst.findFirstToken(13);
                    String paramType = FullIdent.createFullIdentBelow((DetailAST)paramTypeAST).getText();
                    if (NoImplInPublicAPI.isImplementationType(paramType, this.implementationClassSet)) {
                        this.log(paramTypeAST, String.format(PARAM_TYPE_ERROR, paramType), new Object[0]);
                    }
                });
            }
        }
    }

    private static boolean isNonPublicDefinition(DetailAST definitionAst) {
        Scope definitionScope = ScopeUtil.getScope((DetailAST)definitionAst);
        if (definitionScope != Scope.PUBLIC && definitionScope != Scope.PROTECTED) {
            return true;
        }
        Scope containingScope = ScopeUtil.getSurroundingScope((DetailAST)definitionAst);
        return containingScope != null && containingScope != Scope.PUBLIC && containingScope != Scope.PROTECTED;
    }

    private void checkIfTypeParameterImplementationType(DetailAST typeParameterAst) {
        TokenUtil.findFirstTokenByPredicate((DetailAST)typeParameterAst, ast -> ast.getType() == 168).ifPresent(upperBoundsAst -> this.checkAndLogTypeParam(typeParameterAst, (DetailAST)upperBoundsAst));
        TokenUtil.findFirstTokenByPredicate((DetailAST)typeParameterAst, ast -> ast.getType() == 169).ifPresent(lowerBoundsAst -> this.checkAndLogTypeParam(typeParameterAst, (DetailAST)lowerBoundsAst));
        this.checkAndLogTypeParam(typeParameterAst, typeParameterAst);
    }

    private void checkAndLogTypeParam(DetailAST typeParameterAst, DetailAST astToCheck) {
        String type = FullIdent.createFullIdentBelow((DetailAST)astToCheck).getText();
        if (NoImplInPublicAPI.isImplementationType(type, this.implementationClassSet)) {
            this.log(typeParameterAst, String.format(TYPE_PARAM_TYPE_ERROR, type), new Object[0]);
        }
    }

    private void checkExtendsAndImplements(DetailAST definitionAst) {
        TokenUtil.findFirstTokenByPredicate((DetailAST)definitionAst, ast -> ast.getType() == 18).ifPresent(extendsAst -> this.checkAndLogExtendsOrImplements((DetailAST)extendsAst, true));
        TokenUtil.findFirstTokenByPredicate((DetailAST)definitionAst, ast -> ast.getType() == 19).ifPresent(implementsAst -> this.checkAndLogExtendsOrImplements((DetailAST)implementsAst, false));
    }

    private void checkAndLogExtendsOrImplements(DetailAST extendsOrImplements, boolean isExtends) {
        TokenUtil.forEachChild((DetailAST)extendsOrImplements, (int)58, extendsOrImplementsType -> {
            String type = FullIdent.createFullIdent((DetailAST)extendsOrImplementsType).getText();
            if (NoImplInPublicAPI.isImplementationType(type, this.implementationClassSet)) {
                this.log((DetailAST)extendsOrImplementsType, String.format(isExtends ? EXTENDS_TYPE_ERROR : IMPLEMENTS_TYPE_ERROR, type), new Object[0]);
            }
        });
    }

    private static boolean isInStaticInitializer(DetailAST ast) {
        for (DetailAST token = ast.getParent(); token != null; token = token.getParent()) {
            if (!TokenUtil.isOfType((DetailAST)token, (int[])new int[]{12})) continue;
            return true;
        }
        return false;
    }

    private static boolean isImplementationType(String type, Set<String> implementationImports) {
        if (implementationImports.contains(type)) {
            return true;
        }
        return IMPLEMENTATION_CLASS.matcher(type).matches();
    }
}

