/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.linting.extensions.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.DetailNodeTreeStringPrinter;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.utils.BlockCommentPosition;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import io.clientcore.linting.extensions.checkstyle.checks.ImplementationExcludingCheck;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class JavadocThrowsChecks
extends ImplementationExcludingCheck {
    static final String MISSING_DESCRIPTION_MESSAGE = "@throws tag requires a description explaining when the error is thrown.";
    static final String MISSING_THROWS_TAG_MESSAGE = "Javadoc @throws tag required for unchecked throw.";
    private static final int[] TOKENS = new int[]{8, 9, 145, 81, 90, 21, 10};
    private static final String THIS_TOKEN = "this";
    private static final String CLASS_TOKEN = "class";
    private Map<String, Set<String>> javadocThrowsMapping;
    private Map<String, Set<String>> exceptionMapping;
    private String currentScopeIdentifier;
    private boolean currentScopeNeedsChecking;

    @Override
    public int[] getTokensForCheck() {
        return TOKENS;
    }

    public boolean isCommentNodesRequired() {
        return true;
    }

    @Override
    public void beforeTree(DetailAST rootToken) {
        this.javadocThrowsMapping = new HashMap<String, Set<String>>();
        this.exceptionMapping = new HashMap<String, Set<String>>();
        this.currentScopeNeedsChecking = false;
        this.currentScopeIdentifier = "";
    }

    @Override
    public void processToken(DetailAST token) {
        switch (token.getType()) {
            case 8: 
            case 9: {
                this.setIdentifierAndCheckStatus(token);
                break;
            }
            case 145: {
                if (!this.currentScopeNeedsChecking) break;
                this.findJavadocThrows(token);
                break;
            }
            case 81: {
                if (!this.currentScopeNeedsChecking) break;
                this.verifyCheckedThrowJavadoc(token);
                break;
            }
            case 90: {
                if (!this.currentScopeNeedsChecking) break;
                this.verifyUncheckedThrowJavadoc(token);
                break;
            }
            case 10: 
            case 21: {
                if (!this.currentScopeNeedsChecking && token.getParent().getType() != 6) break;
                this.addExceptionMapping(token);
                break;
            }
        }
    }

    private void setIdentifierAndCheckStatus(DetailAST scopeDefToken) {
        this.currentScopeIdentifier = scopeDefToken.findFirstToken(58).getText() + scopeDefToken.getLineNo();
        this.currentScopeNeedsChecking = this.visibilityIsPublicOrProtectedAndNotAbstractOrOverride(scopeDefToken.findFirstToken(5));
    }

    private boolean visibilityIsPublicOrProtectedAndNotAbstractOrOverride(DetailAST modifiersToken) {
        if (modifiersToken == null) {
            return false;
        }
        if (modifiersToken.findFirstToken(40) != null) {
            return false;
        }
        if (modifiersToken.findFirstToken(145) == null && TokenUtil.findFirstTokenByPredicate((DetailAST)modifiersToken, this::isOverrideAnnotation).isPresent()) {
            return false;
        }
        return modifiersToken.findFirstToken(62) != null || modifiersToken.findFirstToken(63) != null;
    }

    private boolean isOverrideAnnotation(DetailAST modifierToken) {
        if (modifierToken.getType() != 159) {
            return false;
        }
        DetailAST identifier = modifierToken.findFirstToken(58);
        return identifier != null && "Override".equals(identifier.getText());
    }

    private void findJavadocThrows(DetailAST blockCommentToken) {
        if (!BlockCommentPosition.isOnMethod((DetailAST)blockCommentToken) && !BlockCommentPosition.isOnConstructor((DetailAST)blockCommentToken)) {
            return;
        }
        DetailNode javadocNode = null;
        try {
            javadocNode = DetailNodeTreeStringPrinter.parseJavadocAsDetailNode((DetailAST)blockCommentToken);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (javadocNode == null) {
            return;
        }
        Set javadocThrows = this.javadocThrowsMapping.getOrDefault(this.currentScopeIdentifier, new HashSet());
        for (DetailNode node : javadocNode.getChildren()) {
            if (node.getType() != 10071 || JavadocUtil.findFirstToken((DetailNode)node, (int)17) == null) continue;
            javadocThrows.add(JavadocUtil.findFirstToken((DetailNode)node, (int)43).getText());
            if (JavadocUtil.findFirstToken((DetailNode)node, (int)10068) != null) continue;
            this.log(node.getLineNumber(), MISSING_DESCRIPTION_MESSAGE, new Object[0]);
        }
        this.javadocThrowsMapping.put(this.currentScopeIdentifier, javadocThrows);
    }

    private void addExceptionMapping(DetailAST definitionToken) {
        DetailAST typeToken = definitionToken.findFirstToken(13).getFirstChild();
        if (typeToken == null) {
            return;
        }
        String scope = this.currentScopeIdentifier;
        if (this.currentScopeIdentifier == null || this.currentScopeIdentifier.isEmpty()) {
            scope = definitionToken.branchContains(64) ? CLASS_TOKEN : THIS_TOKEN;
        }
        String identifier = scope + definitionToken.findFirstToken(58).getText();
        Set types = this.exceptionMapping.getOrDefault(identifier, new HashSet());
        if (typeToken.getType() == 112) {
            TokenUtil.forEachChild((DetailAST)typeToken, (int)58, identityToken -> this.tryToAddType((DetailAST)identityToken, types));
        } else {
            this.tryToAddType(typeToken, types);
        }
        this.exceptionMapping.put(identifier, types);
    }

    private void tryToAddType(DetailAST typeToken, Set<String> types) {
        String type = typeToken.getText();
        if (type.endsWith("Exception") || type.endsWith("Error")) {
            types.add(type);
        }
    }

    private void verifyCheckedThrowJavadoc(DetailAST throwsToken) {
        Set<String> methodJavadocThrows = this.javadocThrowsMapping.get(this.currentScopeIdentifier);
        if (methodJavadocThrows == null) {
            this.log(throwsToken, MISSING_THROWS_TAG_MESSAGE, new Object[0]);
            return;
        }
        TokenUtil.forEachChild((DetailAST)throwsToken, (int)58, throwTypeToken -> {
            if (!methodJavadocThrows.contains(throwTypeToken.getText())) {
                this.log((DetailAST)throwTypeToken, MISSING_THROWS_TAG_MESSAGE, new Object[0]);
            }
        });
    }

    private void verifyUncheckedThrowJavadoc(DetailAST throwToken) {
        Set<String> methodJavadocThrows = this.javadocThrowsMapping.get(this.currentScopeIdentifier);
        if (methodJavadocThrows == null) {
            this.log(throwToken, MISSING_THROWS_TAG_MESSAGE, new Object[0]);
            return;
        }
        DetailAST throwExprToken = throwToken.findFirstToken(28);
        DetailAST literalNewToken = throwExprToken.findFirstToken(136);
        DetailAST methodCallToken = throwExprToken.findFirstToken(27);
        DetailAST typecastToken = throwExprToken.findFirstToken(23);
        if (typecastToken != null) {
            String throwType = typecastToken.findFirstToken(13).findFirstToken(58).getText();
            if (!methodJavadocThrows.contains(throwType)) {
                this.log(throwExprToken, MISSING_THROWS_TAG_MESSAGE, new Object[0]);
            }
        } else if (literalNewToken != null) {
            if (!methodJavadocThrows.contains(literalNewToken.findFirstToken(58).getText())) {
                this.log(throwToken, MISSING_THROWS_TAG_MESSAGE, new Object[0]);
            }
        } else {
            if (methodCallToken != null) {
                return;
            }
            DetailAST lastIdentifier = null;
            DetailAST current = throwExprToken;
            while (current != null) {
                if (current.getType() == 58) {
                    lastIdentifier = current;
                }
                if (current.getFirstChild() != null) {
                    current = current.getFirstChild();
                    continue;
                }
                current = current.getNextSibling();
            }
            if (lastIdentifier == null) {
                return;
            }
            String throwIdentName = lastIdentifier.getText();
            Set<String> types = this.findMatchingExceptionType(this.currentScopeIdentifier, throwIdentName);
            if (types == null) {
                return;
            }
            for (String type : types) {
                if (methodJavadocThrows.contains(type)) continue;
                this.log(throwExprToken, MISSING_THROWS_TAG_MESSAGE, new Object[0]);
            }
        }
    }

    private Set<String> findMatchingExceptionType(String scope, String throwIdent) {
        Set<String> types = this.exceptionMapping.get(scope + throwIdent);
        if (types == null) {
            types = this.exceptionMapping.get(THIS_TOKEN + throwIdent);
        }
        if (types == null) {
            types = this.exceptionMapping.get(CLASS_TOKEN + throwIdent);
        }
        return types;
    }
}

