/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.linting.extensions.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.utils.BlockCommentPosition;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;

public class JavadocInlineTagCheck
extends AbstractJavadocCheck {
    private static final String MULTIPLE_LINE_SPAN_ERROR = "Tag '%s' spans multiple lines. Use @codesnippet annotation instead of '%s' to ensure that the code block always compiles.";

    public int[] getDefaultJavadocTokens() {
        return this.getRequiredJavadocTokens();
    }

    public int[] getRequiredJavadocTokens() {
        return new int[]{10002, 10072};
    }

    public void visitJavadocToken(DetailNode token) {
        DetailAST blockCommentToken = this.getBlockCommentAst();
        if (!BlockCommentPosition.isOnMethod((DetailAST)blockCommentToken) && !BlockCommentPosition.isOnConstructor((DetailAST)blockCommentToken)) {
            return;
        }
        if (token.getType() == 10002) {
            this.checkHtmlElementStart(token);
        } else if (token.getType() == 10072) {
            this.checkJavadocInlineTag(token);
        }
    }

    private void checkHtmlElementStart(DetailNode htmlElementStartNode) {
        DetailNode tagNameNode = JavadocUtil.findFirstToken((DetailNode)htmlElementStartNode, (int)100);
        String tagName = tagNameNode.getText();
        if (!tagName.equalsIgnoreCase("pre") && !tagName.equalsIgnoreCase("code")) {
            return;
        }
        String tagNameBracket = "<" + tagName + ">";
        DetailNode htmlTagNode = htmlElementStartNode.getParent();
        if (!this.isInlineCode(htmlTagNode)) {
            this.log(htmlTagNode.getLineNumber(), htmlTagNode.getColumnNumber(), String.format(MULTIPLE_LINE_SPAN_ERROR, tagNameBracket, tagNameBracket), new Object[0]);
        }
    }

    private void checkJavadocInlineTag(DetailNode inlineTagNode) {
        DetailNode codeLiteralNode = JavadocUtil.findFirstToken((DetailNode)inlineTagNode, (int)45);
        if (codeLiteralNode == null) {
            return;
        }
        String codeLiteral = codeLiteralNode.getText();
        if (!this.isInlineCode(inlineTagNode)) {
            this.log(codeLiteralNode.getLineNumber(), codeLiteralNode.getColumnNumber(), String.format(MULTIPLE_LINE_SPAN_ERROR, codeLiteral, codeLiteral), new Object[0]);
        }
    }

    private boolean isInlineCode(DetailNode node) {
        for (DetailNode child : node.getChildren()) {
            int childType = child.getType();
            if (childType != 6 && childType != 1) continue;
            return false;
        }
        return true;
    }
}

