/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.linting.extensions.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;

public class JavadocFormatting
extends AbstractJavadocCheck {
    private static final String JAVA_DOC_RETURN = "javadoc return";
    private static final String JAVA_DOC_PARAMETER = "javadoc parameter";
    private static final String JAVA_DOC_THROW = "javadoc throw";
    private static final String JAVA_DOC_DEPRECATED = "javadoc deprecated";
    private static final String ERROR_DESCRIPTION_ON_NEW_LINE = "Description for %s must be on same the same line.";
    private static final String ERROR_NO_DESCRIPTION = "Description is missing for %s. Consider adding a description.";
    private static final String ERROR_NO_WS_AFTER_IDENT = "No white space after %s. Consider fixing format.";
    private static final String ERROR_EXTRA_SPACE = "Only one white space is expected after %s. Consider removing extra spaces.";

    public int[] getAcceptableJavadocTokens() {
        return this.getRequiredJavadocTokens();
    }

    public int[] getRequiredJavadocTokens() {
        return new int[]{25, 11, 17, 8};
    }

    public int[] getDefaultJavadocTokens() {
        return this.getRequiredJavadocTokens();
    }

    public void visitJavadocToken(DetailNode javaDocTag) {
        if (javaDocTag.getType() == 11) {
            this.evaluateValidFormat(javaDocTag, JAVA_DOC_RETURN);
        } else if (javaDocTag.getType() == 25) {
            this.evaluateValidFormat(javaDocTag, JAVA_DOC_PARAMETER);
        } else if (javaDocTag.getType() == 17) {
            DetailNode throwFormat = JavadocUtil.getNextSibling((DetailNode)javaDocTag, (int)43);
            this.evaluateValidFormat(throwFormat, JAVA_DOC_THROW);
        } else if (javaDocTag.getType() == 8) {
            this.evaluateValidFormat(javaDocTag, JAVA_DOC_DEPRECATED);
        }
    }

    private void evaluateValidFormat(DetailNode javaDocTag, String identifier) {
        DetailNode nextNodeAfterParameterName = JavadocUtil.getNextSibling((DetailNode)javaDocTag);
        if (nextNodeAfterParameterName.getType() == 6) {
            if (JavadocUtil.getNextSibling((DetailNode)nextNodeAfterParameterName, (int)10068) != null) {
                this.log(javaDocTag.getLineNumber(), String.format(ERROR_DESCRIPTION_ON_NEW_LINE, identifier), new Object[0]);
            } else {
                this.log(javaDocTag.getLineNumber(), String.format(ERROR_NO_DESCRIPTION, identifier), new Object[0]);
            }
        } else if (nextNodeAfterParameterName.getType() != 4) {
            this.log(javaDocTag.getLineNumber(), String.format(ERROR_NO_WS_AFTER_IDENT, identifier), new Object[0]);
        } else if (!nextNodeAfterParameterName.getText().equals(" ")) {
            this.log(javaDocTag.getLineNumber(), String.format(ERROR_EXTRA_SPACE, identifier), new Object[0]);
        }
    }
}

