/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.linting.extensions.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.DetailNodeTreeStringPrinter;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.BlockCommentPosition;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Locale;
import java.util.Queue;

public class JavadocCodeSnippetCheck
extends AbstractCheck {
    private static final String CODE_SNIPPET_ANNOTATION = "@codesnippet";
    private static final int[] TOKENS = new int[]{16, 145, 14, 9};
    private String packageName;
    private final Queue<String> classNameStack = Collections.asLifoQueue(new ArrayDeque());
    private DetailAST methodDefToken = null;

    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    public int[] getRequiredTokens() {
        return TOKENS;
    }

    public boolean isCommentNodesRequired() {
        return true;
    }

    public void leaveToken(DetailAST token) {
        if (token.getType() == 14 && !this.classNameStack.isEmpty()) {
            this.classNameStack.poll();
        }
    }

    public void visitToken(DetailAST token) {
        if (token.getType() == 16) {
            this.packageName = FullIdent.createFullIdent((DetailAST)token.findFirstToken(59)).getText();
        } else if (token.getType() == 14) {
            this.classNameStack.offer(token.findFirstToken(58).getText());
        } else if (token.getType() == 9) {
            this.methodDefToken = token;
        } else if (token.getType() == 145) {
            this.checkNamingPattern(token);
        }
    }

    private void checkNamingPattern(DetailAST blockCommentToken) {
        if (!BlockCommentPosition.isOnMethod((DetailAST)blockCommentToken)) {
            return;
        }
        DetailNode javadocNode = null;
        try {
            javadocNode = DetailNodeTreeStringPrinter.parseJavadocAsDetailNode((DetailAST)blockCommentToken);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (javadocNode == null) {
            return;
        }
        for (DetailNode node : javadocNode.getChildren()) {
            String fullPath;
            if (node.getType() != 10072) continue;
            DetailNode customNameNode = JavadocUtil.findFirstToken((DetailNode)node, (int)21);
            if (customNameNode == null || !CODE_SNIPPET_ANNOTATION.equals(customNameNode.getText())) {
                return;
            }
            DetailNode descriptionNode = JavadocUtil.findFirstToken((DetailNode)node, (int)10068);
            if (descriptionNode == null) {
                return;
            }
            String customDescription = JavadocUtil.findFirstToken((DetailNode)descriptionNode, (int)10074).getText();
            String methodName = this.methodDefToken.findFirstToken(58).getText();
            String className = this.classNameStack.isEmpty() ? "" : this.classNameStack.peek();
            String parameters = this.constructParametersString(this.methodDefToken);
            String fullPathWithoutParameters = fullPath = this.packageName + "." + className + "." + methodName;
            if (parameters != null) {
                fullPath = fullPath + "#" + parameters;
            }
            if (customDescription != null && !customDescription.isEmpty() && this.isNamingMatched(customDescription.toLowerCase(Locale.ROOT), fullPathWithoutParameters.toLowerCase(Locale.ROOT), parameters)) continue;
            this.log(node.getLineNumber(), String.format("Naming pattern mismatch. The @codesnippet description ''%s'' does not match ''%s''. Case Insensitive.", customDescription, fullPath), new Object[0]);
        }
    }

    private String constructParametersString(DetailAST methodDefToken) {
        StringBuilder sb = new StringBuilder();
        DetailAST parametersToken = methodDefToken.findFirstToken(20);
        for (DetailAST ast = parametersToken.getFirstChild(); ast != null; ast = ast.getNextSibling()) {
            if (ast.getType() != 21) continue;
            DetailAST typeToken = ast.findFirstToken(13);
            DetailAST identToken = typeToken.findFirstToken(58);
            String parameterType = "";
            if (identToken != null) {
                parameterType = identToken.getText();
            } else {
                DetailAST arrayDeclarator = typeToken.findFirstToken(17);
                if (arrayDeclarator == null) {
                    parameterType = typeToken.getFirstChild().getText();
                }
                DetailAST arrayDeclaratorIterator = arrayDeclarator;
                while (arrayDeclaratorIterator != null) {
                    DetailAST temp = arrayDeclaratorIterator.findFirstToken(17);
                    if (temp == null) {
                        parameterType = arrayDeclaratorIterator.getFirstChild().getText();
                        break;
                    }
                    arrayDeclaratorIterator = temp;
                }
            }
            sb.append(parameterType).append("-");
        }
        int size = sb.length();
        if (size == 0) {
            return null;
        }
        return sb.substring(0, size - 1);
    }

    private boolean isNamingMatched(String customDescription, String fullPathWithoutParameters, String parameters) {
        String[] descriptionSegments = customDescription.split("#");
        if (descriptionSegments.length == 1) {
            if (parameters != null) {
                return false;
            }
            String pathUntilMethodName = descriptionSegments[0].split("-")[0];
            if (!fullPathWithoutParameters.equalsIgnoreCase(pathUntilMethodName)) {
                return false;
            }
        }
        if (descriptionSegments.length == 2) {
            if (parameters != null) {
                return descriptionSegments[1].regionMatches(true, 0, parameters, 0, parameters.length());
            }
            return false;
        }
        return true;
    }
}

