/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.linting.extensions.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtil;
import java.util.Stack;

public class ImmutableClassCheck
extends AbstractCheck {
    private static final String IMMUTABLE_NOTATION = "Immutable";
    static final String PUBLIC_FIELD_ERROR_TEMPLATE = "Classes annotated with @Immutable cannot have non-final public or protect fields. Found non-final public field: %s.";
    static final String SETTER_METHOD_ERROR_TEMPLATE = "Classes annotated with @Immutable cannot have public or protected setter methods. Found public setter method: %s.";
    private Stack<Boolean> hasImmutableAnnotationStack;

    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    public int[] getRequiredTokens() {
        return new int[]{14, 10, 9};
    }

    public void beginTree(DetailAST root) {
        this.hasImmutableAnnotationStack = new Stack();
    }

    public void visitToken(DetailAST token) {
        if (token.getType() == 14) {
            this.hasImmutableAnnotationStack.add(ImmutableClassCheck.hasImmutableAnnotation(token));
        } else if (token.getType() == 10 && this.isInImmutableClass()) {
            this.checkForPublicField(token);
        } else if (token.getType() == 9 && this.isInImmutableClass()) {
            this.checkForSetterMethod(token);
        }
    }

    private boolean isInImmutableClass() {
        return !this.hasImmutableAnnotationStack.isEmpty() && this.hasImmutableAnnotationStack.peek() != false;
    }

    public void leaveToken(DetailAST ast) {
        if (ast.getType() == 14 && !this.hasImmutableAnnotationStack.isEmpty()) {
            this.hasImmutableAnnotationStack.pop();
        }
    }

    private static boolean hasImmutableAnnotation(DetailAST classDefinition) {
        return AnnotationUtil.getAnnotation((DetailAST)classDefinition, (String)IMMUTABLE_NOTATION) != null;
    }

    private void checkForPublicField(DetailAST variableDefinition) {
        DetailAST modifiers = variableDefinition.findFirstToken(5);
        if (modifiers == null || modifiers.findFirstToken(39) != null) {
            return;
        }
        if (ImmutableClassCheck.isScopeAndSurroundingScopePublic(variableDefinition)) {
            this.log(variableDefinition, String.format(PUBLIC_FIELD_ERROR_TEMPLATE, variableDefinition.findFirstToken(58).getText()), new Object[0]);
        }
    }

    private void checkForSetterMethod(DetailAST methodDefinition) {
        String methodName = methodDefinition.findFirstToken(58).getText();
        if (!ImmutableClassCheck.isSetterMethod(methodName)) {
            return;
        }
        if (ImmutableClassCheck.isScopeAndSurroundingScopePublic(methodDefinition)) {
            this.log(methodDefinition, String.format(SETTER_METHOD_ERROR_TEMPLATE, methodName), new Object[0]);
        }
    }

    private static boolean isSetterMethod(String methodName) {
        return methodName.startsWith("set") && methodName.length() >= 4 && Character.isUpperCase(methodName.charAt(3));
    }

    private static boolean isScopeAndSurroundingScopePublic(DetailAST detailAST) {
        Scope scope = ScopeUtil.getScope((DetailAST)detailAST);
        Scope surroundingScope = ScopeUtil.getSurroundingScope((DetailAST)detailAST);
        return !(scope != Scope.PUBLIC && scope != Scope.PROTECTED || surroundingScope != Scope.PUBLIC && surroundingScope != Scope.PROTECTED);
    }
}

