/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.linting.extensions.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.checks.naming.AccessModifierOption;
import com.puppycrawl.tools.checkstyle.utils.CheckUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;

public class HttpPipelinePolicyCheck
extends AbstractCheck {
    private static final String HTTP_PIPELINE_POLICY = "HttpPipelinePolicy";
    private boolean isImplementationPackage;

    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    public int[] getRequiredTokens() {
        return new int[]{16, 14};
    }

    public void visitToken(DetailAST token) {
        if (token.getType() == 16) {
            String packageName = FullIdent.createFullIdent((DetailAST)token.findFirstToken(59)).getText();
            this.isImplementationPackage = packageName.contains("implementation");
        } else if (token.getType() == 14) {
            this.checkPublicNonImplementationPolicyClass(token);
        }
    }

    private void checkPublicNonImplementationPolicyClass(DetailAST classDefToken) {
        DetailAST implementsClauseToken = classDefToken.findFirstToken(19);
        if (implementsClauseToken == null) {
            return;
        }
        TokenUtil.findFirstTokenByPredicate((DetailAST)implementsClauseToken, node -> node.getType() == 58 && HTTP_PIPELINE_POLICY.equals(node.getText())).ifPresent(ignored -> {
            String className = classDefToken.findFirstToken(58).getText();
            if (CheckUtil.getAccessModifierFromModifiersToken((DetailAST)classDefToken) != AccessModifierOption.PUBLIC) {
                this.log(classDefToken, String.format("Class ''%s'' implementing ''%s'' and should be a public class", className, HTTP_PIPELINE_POLICY), new Object[0]);
            }
            if (this.isImplementationPackage) {
                this.log(classDefToken, String.format("Class ''%s'' implementing ''%s'' and should not be a implementation package or sub-package of it", className, HTTP_PIPELINE_POLICY), new Object[0]);
            }
        });
    }
}

