/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.linting.extensions.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Queue;

public class GoodLoggingCheck
extends AbstractCheck {
    private static final int[] REQUIRED_TOKENS = new int[]{30, 15, 154, 14, 136, 10, 27};
    static final String LOGGER_NAME_ERROR = "ClientLogger instance naming: use \"%s\" instead of \"%s\" for consistency.";
    static final String NOT_CLIENT_LOGGER_ERROR = "Do not use %s class. Use \"%s\" as a logging mechanism instead of \"%s\".";
    static final String LOGGER_NAME_MISMATCH_ERROR = "Not newing a ClientLogger with matching class name. Use \"%s.class\" instead of \"%s\".";
    private boolean hasClientLoggerImported;
    private final Queue<String> classNameDeque = Collections.asLifoQueue(new ArrayDeque());
    private static final String[] INVALID_LOGS = new String[]{"org.slf4j", "org.apache.logging.log4j", "java.util.logging"};
    private String fullyQualifiedLoggerName;
    private String simpleClassName;
    private String loggerName;

    public final void setFullyQualifiedLoggerName(String fullyQualifiedLoggerName) {
        if (fullyQualifiedLoggerName == null || fullyQualifiedLoggerName.isEmpty()) {
            throw new IllegalArgumentException("fullyQualifiedLoggerName cannot be null or empty.");
        }
        this.fullyQualifiedLoggerName = fullyQualifiedLoggerName;
    }

    public final void setSimpleClassName(String simpleClassName) {
        if (simpleClassName == null || simpleClassName.isEmpty()) {
            throw new IllegalArgumentException("simpleClassName cannot be null or empty.");
        }
        this.simpleClassName = simpleClassName;
    }

    public final void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    public int[] getRequiredTokens() {
        return REQUIRED_TOKENS;
    }

    public void beginTree(DetailAST rootAST) {
        ArrayList<String> missingConfig = new ArrayList<String>(3);
        if (this.fullyQualifiedLoggerName == null || this.fullyQualifiedLoggerName.isEmpty()) {
            missingConfig.add("fullyQualifiedLoggerName");
        }
        if (this.simpleClassName == null || this.simpleClassName.isEmpty()) {
            missingConfig.add("simpleClassName");
        }
        if (this.loggerName == null || this.loggerName.isEmpty()) {
            missingConfig.add("loggerName");
        }
        if (!missingConfig.isEmpty()) {
            throw new IllegalArgumentException("GoodLoggingCheck configuration error, missing the following configurations: " + String.join((CharSequence)", ", missingConfig));
        }
    }

    public void finishTree(DetailAST ast) {
        this.hasClientLoggerImported = false;
    }

    public void leaveToken(DetailAST ast) {
        if (ast.getType() == 14 || ast.getType() == 15 || ast.getType() == 154) {
            this.classNameDeque.poll();
        }
    }

    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 30: {
                String importClassPath = FullIdent.createFullIdentBelow((DetailAST)ast).getText();
                this.hasClientLoggerImported = this.hasClientLoggerImported || importClassPath.equals(this.fullyQualifiedLoggerName);
                for (String invalidLog : INVALID_LOGS) {
                    if (!importClassPath.startsWith(invalidLog)) continue;
                    this.log(ast, String.format(NOT_CLIENT_LOGGER_ERROR, "external logger", this.fullyQualifiedLoggerName, invalidLog), new Object[0]);
                }
                break;
            }
            case 14: 
            case 15: 
            case 154: {
                this.classNameDeque.offer(ast.findFirstToken(58).getText());
                break;
            }
            case 136: {
                this.checkLoggerInstantiation(ast);
                break;
            }
            case 10: {
                this.checkLoggerNameMatch(ast);
                break;
            }
            case 27: {
                DetailAST dotToken = ast.findFirstToken(59);
                if (dotToken == null) {
                    return;
                }
                String methodCallName = FullIdent.createFullIdentBelow((DetailAST)dotToken).getText();
                if (!methodCallName.startsWith("System.out") && !methodCallName.startsWith("System.err")) break;
                this.log(ast, String.format(NOT_CLIENT_LOGGER_ERROR, "Java System", this.fullyQualifiedLoggerName, methodCallName), new Object[0]);
                break;
            }
        }
    }

    private boolean isTypeClientLogger(DetailAST varDefAST) {
        DetailAST typeAST = varDefAST.findFirstToken(13);
        if (typeAST == null) {
            return false;
        }
        return TokenUtil.findFirstTokenByPredicate((DetailAST)typeAST, node -> node.getType() == 58 && node.getText().equals(this.simpleClassName)).isPresent();
    }

    private void checkLoggerInstantiation(DetailAST literalNewToken) {
        DetailAST identToken = literalNewToken.findFirstToken(58);
        if (identToken == null || !identToken.getText().equals(this.simpleClassName)) {
            return;
        }
        TokenUtil.findFirstTokenByPredicate((DetailAST)literalNewToken.findFirstToken(34), exprToken -> {
            if (exprToken.getType() != 28 || exprToken.getFirstChild().getType() != 59) {
                return false;
            }
            String containerClassName = FullIdent.createFullIdent((DetailAST)exprToken.getFirstChild()).getText();
            String className = this.classNameDeque.peek();
            if (!Objects.equals(className + ".class", containerClassName)) {
                this.log((DetailAST)exprToken, String.format(LOGGER_NAME_MISMATCH_ERROR, className, containerClassName), new Object[0]);
            }
            return true;
        });
    }

    private void checkLoggerNameMatch(DetailAST varToken) {
        if (!this.hasClientLoggerImported || !this.isTypeClientLogger(varToken)) {
            return;
        }
        DetailAST identAST = varToken.findFirstToken(58);
        if (identAST != null && !identAST.getText().equalsIgnoreCase(this.loggerName)) {
            this.log(varToken, String.format(LOGGER_NAME_ERROR, this.loggerName, identAST.getText()), new Object[0]);
        }
    }
}

