/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.linting.extensions.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Queue;

public class FluentMethodNameCheck
extends AbstractCheck {
    private final Queue<String> classNameStack = Collections.asLifoQueue(new ArrayDeque());
    private String[] disallowedPrefixes = new String[0];

    public final void setDisallowedPrefixes(String ... disallowedPrefixes) {
        if (disallowedPrefixes != null) {
            this.disallowedPrefixes = Arrays.copyOf(disallowedPrefixes, disallowedPrefixes.length);
        }
    }

    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    public int[] getRequiredTokens() {
        return new int[]{14, 9};
    }

    public void visitToken(DetailAST token) {
        if (token.getType() == 14) {
            this.classNameStack.offer(token.findFirstToken(58).getText());
        } else if (token.getType() == 9 && this.isFluentMethod(token)) {
            this.checkMethodNamePrefix(token);
            if (token.findFirstToken(81) != null) {
                this.log(token, String.format("Fluent Method ''%s'' must not be declared to throw any checked exceptions.", token.findFirstToken(58).getText()), new Object[0]);
            }
        }
    }

    public void leaveToken(DetailAST token) {
        if (token.getType() == 14 && !this.classNameStack.isEmpty()) {
            this.classNameStack.poll();
        }
    }

    private void checkMethodNamePrefix(DetailAST methodDefToken) {
        DetailAST typeToken;
        if (TokenUtil.findFirstTokenByPredicate((DetailAST)methodDefToken, parameters -> parameters.getType() == 20 && parameters.getChildCount() != 1).isPresent()) {
            this.log(methodDefToken, "A fluent method should only have one parameter.", new Object[0]);
        }
        if (TokenUtil.findFirstTokenByPredicate((DetailAST)(typeToken = methodDefToken.findFirstToken(13)), ident -> ident.getType() == 58 && !ident.getText().equals(this.classNameStack.peek())).isPresent()) {
            this.log(methodDefToken, "Return type of fluent method should be the class itself", new Object[0]);
        }
        String methodName = methodDefToken.findFirstToken(58).getText();
        for (String avoidStartWord : this.disallowedPrefixes) {
            if (!methodName.startsWith(avoidStartWord)) continue;
            this.log(methodDefToken, String.format("''%s'' fluent method name should not start with keyword ''%s''.", methodName, avoidStartWord), new Object[0]);
        }
    }

    private boolean isFluentMethod(DetailAST methodDefToken) {
        DetailAST modifiersToken = methodDefToken.findFirstToken(5);
        return TokenUtil.findFirstTokenByPredicate((DetailAST)modifiersToken, annotationToken -> annotationToken.getType() == 159).flatMap(annotationToken -> TokenUtil.findFirstTokenByPredicate((DetailAST)annotationToken, identToken -> identToken.getType() == 58 && "Fluent".equals(identToken.getText()))).isPresent();
    }
}

