/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.linting.extensions.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import io.clientcore.linting.extensions.checkstyle.checks.ImplementationExcludingCheck;
import io.clientcore.linting.extensions.checkstyle.checks.SdkCheckUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ExternalDependencyExposedCheck
extends ImplementationExcludingCheck {
    private static final String EXTERNAL_DEPENDENCY_ERROR = "Class ''%s'', is a class from external dependency. You should not use it as a %s type.";
    private static final String[] ALWAYS_ALLOWED = new String[]{"java.", "javax."};
    private final Map<String, String> simpleClassNameToQualifiedNameMap = new HashMap<String, String>();
    private boolean isPublicClass;
    private String[] allowedDependencyPrefixes = new String[0];

    public final void setAllowedDependencyPrefixes(String ... allowedDependencyPrefixes) {
        if (allowedDependencyPrefixes != null) {
            this.allowedDependencyPrefixes = Arrays.copyOf(allowedDependencyPrefixes, allowedDependencyPrefixes.length);
        }
    }

    @Override
    public void beforeTree(DetailAST rootAST) {
        this.simpleClassNameToQualifiedNameMap.clear();
    }

    @Override
    public int[] getTokensForCheck() {
        return new int[]{30, 14, 9};
    }

    @Override
    public void processToken(DetailAST token) {
        int tokenType = token.getType();
        if (tokenType == 30) {
            String importClassPath = FullIdent.createFullIdentBelow((DetailAST)token).getText();
            String className = importClassPath.substring(importClassPath.lastIndexOf(".") + 1);
            this.simpleClassNameToQualifiedNameMap.put(className, importClassPath);
        } else if (tokenType == 14) {
            this.isPublicClass = SdkCheckUtils.isPublicOrProtected(token);
        } else if (tokenType == 9) {
            if (!this.isPublicClass) {
                return;
            }
            this.checkNoExternalDependencyExposed(token);
        }
    }

    private void checkNoExternalDependencyExposed(DetailAST methodDefToken) {
        DetailAST parametersToken;
        if (!SdkCheckUtils.isPublicOrProtected(methodDefToken)) {
            return;
        }
        DetailAST typeToken = methodDefToken.findFirstToken(13);
        if (typeToken != null) {
            this.getInvalidReturnTypes(typeToken).forEach((token, returnTypeName) -> this.log((DetailAST)token, String.format(EXTERNAL_DEPENDENCY_ERROR, returnTypeName, "return"), new Object[0]));
        }
        if ((parametersToken = methodDefToken.findFirstToken(20)) != null) {
            this.getInvalidParameterTypes(parametersToken).forEach((token, parameterTypeName) -> this.log((DetailAST)token, String.format(EXTERNAL_DEPENDENCY_ERROR, parameterTypeName, "method argument"), new Object[0]));
        }
    }

    private Map<DetailAST, String> getInvalidReturnTypes(DetailAST typeToken) {
        DetailAST typeArgumentsToken;
        HashMap<DetailAST, String> invalidReturnTypeMap = new HashMap<DetailAST, String>();
        DetailAST identToken = typeToken.findFirstToken(58);
        if (identToken == null) {
            return invalidReturnTypeMap;
        }
        String typeName = identToken.getText();
        if (!this.isValidClassDependency(typeName)) {
            invalidReturnTypeMap.put(typeToken, typeName);
        }
        if ((typeArgumentsToken = typeToken.findFirstToken(163)) != null) {
            this.getInvalidParameterType(typeArgumentsToken, invalidReturnTypeMap);
        }
        return invalidReturnTypeMap;
    }

    private Map<DetailAST, String> getInvalidParameterTypes(DetailAST parametersTypeToken) {
        HashMap<DetailAST, String> invalidParameterTypesMap = new HashMap<DetailAST, String>();
        for (DetailAST ast = parametersTypeToken.getFirstChild(); ast != null; ast = ast.getNextSibling()) {
            if (ast.getType() != 21) continue;
            this.getInvalidParameterType(ast.findFirstToken(13), invalidParameterTypesMap);
        }
        return invalidParameterTypesMap;
    }

    private void getInvalidParameterType(DetailAST token, Map<DetailAST, String> invalidTypesMap) {
        if (token == null) {
            return;
        }
        for (DetailAST ast = token.getFirstChild(); ast != null; ast = ast.getNextSibling()) {
            int tokenType = ast.getType();
            if (tokenType == 58) {
                String identName = ast.getText();
                if (this.isValidClassDependency(identName)) continue;
                invalidTypesMap.put(ast, identName);
                continue;
            }
            if (tokenType != 164 && tokenType != 163) continue;
            this.getInvalidParameterType(ast, invalidTypesMap);
        }
    }

    private boolean isValidClassDependency(String typeName) {
        String qualifiedName = this.simpleClassNameToQualifiedNameMap.get(typeName);
        if (qualifiedName == null) {
            return true;
        }
        for (String allowedPrefix : ALWAYS_ALLOWED) {
            if (!qualifiedName.startsWith(allowedPrefix)) continue;
            return true;
        }
        for (String prefix : this.allowedDependencyPrefixes) {
            if (!qualifiedName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

