/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.linting.extensions.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;

public class ExceptionCreatedButNotThrownCheck
extends AbstractCheck {
    static final String ERROR_MESSAGE = "An exception is created and logged, but not thrown. Ensure the exception is either thrown or not created at all. See https://github.com/Azure/azure-sdk-for-java/wiki/Client-core:-logging-exceptions-best-practices for more details.";
    private static final String[] THROWABLE_AT_LOGGING_METHODS = new String[]{".throwableAtError", ".throwableAtWarning"};

    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    public int[] getRequiredTokens() {
        return new int[]{27};
    }

    public void visitToken(DetailAST token) {
        if (ExceptionCreatedButNotThrownCheck.isThrowableAtLoggingMethod(token) && !ExceptionCreatedButNotThrownCheck.isInsideThrow(token)) {
            DetailAST logMethodCall = token.getParent().getParent();
            if (logMethodCall == null || logMethodCall.getType() != 27) {
                return;
            }
            String nextName = FullIdent.createFullIdentBelow((DetailAST)logMethodCall).getText();
            if (nextName.endsWith(".log")) {
                this.log(token, ERROR_MESSAGE, new Object[0]);
            }
        }
    }

    private static boolean isThrowableAtLoggingMethod(DetailAST methodCallAst) {
        String methodName = FullIdent.createFullIdentBelow((DetailAST)methodCallAst).getText();
        for (String logMethod : THROWABLE_AT_LOGGING_METHODS) {
            if (!methodName.endsWith(logMethod)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInsideThrow(DetailAST methodCallAst) {
        DetailAST parent;
        for (parent = methodCallAst.getParent(); parent != null && (parent.getType() == 59 || parent.getType() == 28 || parent.getType() == 23 || parent.getType() == 27); parent = parent.getParent()) {
        }
        return parent != null && parent.getType() == 90;
    }
}

