/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.linting.extensions.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.CheckUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import io.clientcore.linting.extensions.checkstyle.checks.SdkCheckUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class EnforceFinalFieldsCheck
extends AbstractCheck {
    private static final String ERROR_SUGGESTION = "You should consider making the field final, or suppressing the warning.";
    private static final String ERROR_MSG = "Field \"%s\" is only assigned in constructor and it is not final. You should consider making the field final, or suppressing the warning.";
    private static final String ERROR_FIELD_ALONE = "Field \"%s\" is not assigned in constructor or methods.You should consider making the field final, or suppressing the warning.";
    private List<DetailAST> nonFinalFields;
    private Set<String> assignmentsFromConstructor;
    private Set<String> assignmentsFromMethods;
    private DetailAST scopeParent = null;
    private Set<String> currentScopeParameterSet = null;
    private Map<String, DetailAST> variablesInScope = null;
    private String currentClassName = null;

    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    public int[] getRequiredTokens() {
        return new int[]{14, 80, 98, 106, 108, 104, 107, 101, 99, 102, 105, 103, 100, 129, 25, 130, 26, 9, 8};
    }

    public void beginTree(DetailAST root) {
        this.nonFinalFields = new ArrayList<DetailAST>();
        this.assignmentsFromConstructor = new HashSet<String>();
        this.assignmentsFromMethods = new HashSet<String>();
    }

    public void visitToken(DetailAST token) {
        switch (token.getType()) {
            case 14: {
                this.currentClassName = token.findFirstToken(58).getText();
                this.fillClassFieldDefinitions(token);
                break;
            }
            case 25: 
            case 26: 
            case 80: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 129: 
            case 130: {
                this.checkAssignation(token);
                break;
            }
            case 8: 
            case 9: {
                this.scopeParent = token;
                this.variablesInScope = new HashMap<String, DetailAST>();
                break;
            }
        }
    }

    public void leaveToken(DetailAST token) {
        switch (token.getType()) {
            case 8: 
            case 9: {
                this.scopeParent = null;
                this.currentScopeParameterSet = null;
                this.variablesInScope = null;
                break;
            }
        }
    }

    public void finishTree(DetailAST token) {
        for (DetailAST field : this.nonFinalFields) {
            String fieldName = field.findFirstToken(58).getText();
            if (this.assignmentsFromConstructor.contains(fieldName) && !this.assignmentsFromMethods.contains(fieldName)) {
                this.log(field, String.format(ERROR_MSG, fieldName), new Object[0]);
                continue;
            }
            if (!field.branchContains(80) || this.assignmentsFromConstructor.contains(fieldName) || this.assignmentsFromMethods.contains(fieldName)) continue;
            this.log(field, String.format(ERROR_FIELD_ALONE, fieldName), new Object[0]);
        }
    }

    private DetailAST getAssignedField(DetailAST assignationToken) {
        DetailAST assignationWithDot;
        Set<String> scopeParentParameterSet = this.getParameterSet(this.scopeParent.findFirstToken(20));
        DetailAST firstChild = assignationToken.getFirstChild();
        Object object = assignationWithDot = firstChild.getType() == 59 ? firstChild : null;
        if (assignationWithDot != null) {
            if (assignationWithDot.findFirstToken(78) != null) {
                return assignationWithDot.findFirstToken(58);
            }
            if (TokenUtil.findFirstTokenByPredicate((DetailAST)assignationWithDot, token -> token.getText().equals(this.currentClassName)).isPresent()) {
                return assignationWithDot.getLastChild();
            }
            if (assignationWithDot.getFirstChild().getType() == 58) {
                String variableNameToken = assignationWithDot.getFirstChild().getText();
                DetailAST variableDeclaration = this.variablesInScope.get(variableNameToken);
                DetailAST parentScope = EnforceFinalFieldsCheck.getParentScope(assignationToken);
                if (variableDeclaration != null && parentScope != null && CheckUtil.isBeforeInSource((DetailAST)variableDeclaration, (DetailAST)parentScope)) {
                    return assignationWithDot.getLastChild();
                }
            }
        } else {
            DetailAST variableNameToken = assignationToken.getFirstChild();
            if (!scopeParentParameterSet.contains(variableNameToken.getText())) {
                return variableNameToken;
            }
        }
        return null;
    }

    private static DetailAST getParentScope(DetailAST ast) {
        DetailAST parent = ast.getParent();
        do {
            if (parent.getType() != 7) continue;
            return parent;
        } while ((parent = parent.getParent()) != null);
        return null;
    }

    private void saveField(String fieldName, int scopeParentType) {
        if (scopeParentType == 9) {
            this.assignmentsFromMethods.add(fieldName);
        } else if (scopeParentType == 8) {
            this.assignmentsFromConstructor.add(fieldName);
        }
    }

    private void checkAssignation(DetailAST assignationToken) {
        if (this.scopeParent == null || assignationToken.getChildCount() == 0) {
            return;
        }
        DetailAST assignationParent = assignationToken.getParent();
        if (assignationParent != null && 10 == assignationParent.getType()) {
            String variableType = FullIdent.createFullIdentBelow((DetailAST)assignationParent.findFirstToken(13)).getText();
            if (Objects.equals(this.currentClassName, variableType)) {
                this.variablesInScope.put(assignationParent.findFirstToken(58).getText(), assignationParent);
            }
            return;
        }
        DetailAST fieldToken = this.getAssignedField(assignationToken);
        if (fieldToken != null) {
            this.saveField(fieldToken.getText(), this.scopeParent.getType());
        }
    }

    private void fillClassFieldDefinitions(DetailAST classDefinitionAST) {
        DetailAST classObjBlockAst = classDefinitionAST.findFirstToken(6);
        TokenUtil.forEachChild((DetailAST)classObjBlockAst, (int)10, definitionToken -> {
            DetailAST variableModifiersAst = definitionToken.findFirstToken(5);
            if (variableModifiersAst.findFirstToken(39) == null && !SdkCheckUtils.hasIllegalCombination(variableModifiersAst)) {
                this.nonFinalFields.add((DetailAST)definitionToken);
            }
        });
    }

    private Set<String> getParameterSet(DetailAST parametersAST) {
        if (this.currentScopeParameterSet != null) {
            return this.currentScopeParameterSet;
        }
        this.currentScopeParameterSet = new HashSet<String>();
        TokenUtil.forEachChild((DetailAST)parametersAST, (int)21, paramDefToken -> {
            String parameterName = paramDefToken.findFirstToken(58).getText();
            this.currentScopeParameterSet.add(parameterName);
        });
        return this.currentScopeParameterSet;
    }
}

