/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.linting.extensions.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtil;
import io.clientcore.linting.extensions.checkstyle.checks.ImplementationExcludingCheck;
import io.clientcore.linting.extensions.checkstyle.checks.SdkCheckUtils;
import java.util.Arrays;

public class DenyListedWordsCheck
extends ImplementationExcludingCheck {
    static final String ERROR_MESSAGE_TEMPLATE = ": All public API classes, methods, and fields should follow camelcase standards for the following words: ";
    private String[] denyListedWords = new String[0];
    String computedErrorMessage;

    public final void setDenyListedWords(String ... denyListedWords) {
        if (denyListedWords != null) {
            this.denyListedWords = Arrays.copyOf(denyListedWords, denyListedWords.length);
            this.computedErrorMessage = ERROR_MESSAGE_TEMPLATE + String.join((CharSequence)", ", this.denyListedWords);
        }
    }

    @Override
    public int[] getTokensForCheck() {
        return new int[]{14, 15, 9, 10};
    }

    @Override
    public void processToken(DetailAST token) {
        if (!this.isPublicApi(token)) {
            return;
        }
        String tokenName = token.findFirstToken(58).getText();
        if (!this.hasDenyListedWords(tokenName)) {
            return;
        }
        if (token.getType() == 10 && ScopeUtil.isInInterfaceBlock((DetailAST)token)) {
            return;
        }
        this.log(token, tokenName + this.computedErrorMessage, new Object[0]);
    }

    private boolean isPublicApi(DetailAST token) {
        DetailAST modifiersAST = token.findFirstToken(5);
        return SdkCheckUtils.isPublicOrProtected(token) && modifiersAST.findFirstToken(64) == null;
    }

    private boolean hasDenyListedWords(String tokenName) {
        for (String denyListedWord : this.denyListedWords) {
            if (!tokenName.contains(denyListedWord)) continue;
            return true;
        }
        return false;
    }
}

