/*
 * Decompiled with CFR 0.152.
 */
package io.chatpal.solr.ext.update.processor;

import java.io.IOException;
import java.util.Objects;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;

public class LanguageFieldUpdateProcessorFactory
extends UpdateRequestProcessorFactory {
    private static final String SOURCE = "source";
    private static final String TARGET = "target";
    private String sourceField;
    private String targetFieldPattern;
    private boolean isPrefix;

    public void init(NamedList args) {
        super.init(args);
        this.sourceField = Objects.toString(args.get(SOURCE), null);
        if (this.sourceField == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing configuration: source");
        }
        this.targetFieldPattern = Objects.toString(args.get(TARGET), null);
        if (this.targetFieldPattern == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing configuration: target");
        }
        this.isPrefix = !this.targetFieldPattern.contains("*");
    }

    public UpdateRequestProcessor getInstance(final SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        final String lang = req.getParams().get("language", "none");
        return new UpdateRequestProcessor(next){

            public void processAdd(AddUpdateCommand cmd) throws IOException {
                SolrInputField field = cmd.solrDoc.getField(LanguageFieldUpdateProcessorFactory.this.sourceField);
                if (field != null) {
                    String targetField = LanguageFieldUpdateProcessorFactory.this.isPrefix ? LanguageFieldUpdateProcessorFactory.this.targetFieldPattern + lang : LanguageFieldUpdateProcessorFactory.this.targetFieldPattern.replace("*", lang);
                    if (req.getSchema().getFieldOrNull(targetField) != null) {
                        cmd.solrDoc.setField(targetField, field.getValue());
                    }
                    cmd.solrDoc.removeField(LanguageFieldUpdateProcessorFactory.this.sourceField);
                }
                super.processAdd(cmd);
            }
        };
    }
}

