/*
 * Decompiled with CFR 0.152.
 */
package io.chatpal.solr.ext.update.processor;

import java.io.IOException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;

public class IdGenerationFieldUpdateProcessorFactory
extends UpdateRequestProcessorFactory {
    private static final String TARGET = "targetField";
    private static final String PATTERN = "pattern";
    private static final Pattern REGEX = Pattern.compile("(?<!\\\\)\\{([^:}]+)(?::([^}]*))?}");
    private String targetField;
    private String pattern;
    private boolean multiValued = false;

    public void init(NamedList args) {
        super.init(args);
        this.targetField = Objects.toString(args.get(TARGET), null);
        if (this.targetField == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing configuration: targetField");
        }
        this.pattern = Objects.toString(args.get(PATTERN), null);
        if (this.pattern == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing configuration: pattern");
        }
    }

    public UpdateRequestProcessor getInstance(final SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        return new UpdateRequestProcessor(next){

            public void processAdd(AddUpdateCommand cmd) throws IOException {
                SchemaField target = req.getSchema().getFieldOrNull(IdGenerationFieldUpdateProcessorFactory.this.targetField);
                if (target != null) {
                    Matcher matcher = REGEX.matcher(IdGenerationFieldUpdateProcessorFactory.this.pattern);
                    StringBuffer result = new StringBuffer();
                    while (matcher.find()) {
                        String g0 = matcher.group();
                        String fName = matcher.group(1);
                        String fallback = StringUtils.defaultString((String)matcher.group(2), (String)g0);
                        SolrInputField field = cmd.solrDoc.getField(fName);
                        if (field != null) {
                            matcher.appendReplacement(result, String.valueOf(field.getFirstValue()));
                            continue;
                        }
                        matcher.appendReplacement(result, fallback);
                    }
                    matcher.appendTail(result);
                    if (target.multiValued() && IdGenerationFieldUpdateProcessorFactory.this.multiValued) {
                        cmd.solrDoc.addField(target.getName(), (Object)result.toString());
                    } else {
                        cmd.solrDoc.setField(target.getName(), (Object)result.toString());
                    }
                }
                super.processAdd(cmd);
            }
        };
    }
}

