/*
 * Decompiled with CFR 0.152.
 */
package io.chatpal.solr.ext.handler;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.StringUtils;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.SearchHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuggestionRequestHandler
extends SearchHandler {
    private Logger logger = LoggerFactory.getLogger(SuggestionRequestHandler.class);
    private static final int MAX_SIZE = 10;

    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        ModifiableSolrParams params = new ModifiableSolrParams();
        String text = req.getParams().get("text");
        if (StringUtils.isEmpty((String)text)) {
            rsp.getValues().add("suggestion", Collections.emptyList());
            return;
        }
        params.set("q", new String[]{"*:*"});
        params.set("rows", 0);
        params.set("facet", true);
        params.set("facet.field", new String[]{"suggestion"});
        params.set("facet.mincount", 1);
        params.set("facet.limit", 15);
        CharSequence[] typeParams = req.getParams().getParams("type[]");
        if (typeParams != null) {
            String types = String.join((CharSequence)" OR ", typeParams);
            params.add("fq", new String[]{"type:(" + types + ")"});
        }
        List<String> tokens = Stream.of(text.split(" ")).map(String::toLowerCase).collect(Collectors.toList());
        text = text.endsWith(" ") ? null : (String)tokens.remove(tokens.size() - 1);
        tokens.forEach(t -> params.add("fq", new String[]{"suggestion:" + t}));
        params.set("facet.prefix", new String[]{text});
        this.appendACLFilter(params, req);
        LocalSolrQueryRequest userRequest = new LocalSolrQueryRequest(req.getCore(), (SolrParams)params);
        SolrQueryResponse response = new SolrQueryResponse();
        super.handleRequestBody((SolrQueryRequest)userRequest, response);
        Iterator entries = ((NamedList)((SimpleOrderedMap)((SimpleOrderedMap)response.getValues().get("facet_counts")).get("facet_fields")).get("suggestion")).iterator();
        ArrayList<ImmutableMap> suggestions = new ArrayList<ImmutableMap>();
        String prefix = tokens.stream().collect(Collectors.joining(" "));
        if (prefix.length() > 0) {
            prefix = prefix + " ";
        }
        while (entries.hasNext()) {
            Map.Entry entry = (Map.Entry)entries.next();
            if (!tokens.contains(entry.getKey())) {
                suggestions.add(ImmutableMap.of((Object)"text", (Object)(prefix + entry.getKey()), (Object)"count", entry.getValue()));
            }
            if (suggestions.size() != 10) continue;
            break;
        }
        rsp.getValues().add("suggestion", suggestions);
    }

    private void appendACLFilter(ModifiableSolrParams query, SolrQueryRequest req) {
        query.add("fq", new String[]{this.buildACLFilter(req.getParams())});
    }

    private String buildACLFilter(SolrParams params) {
        return this.buildOrFilter(params, "acl[]", "rid");
    }

    private String buildOrFilter(SolrParams solrParams, String param, String field) {
        String[] values = solrParams.getParams(param);
        if (values == null || values.length < 1) {
            return "-" + field + ":*";
        }
        return "{!q.op=OR}" + field + ":" + Arrays.stream(values).map(ClientUtils::escapeQueryChars).collect(Collectors.joining(" ", "(", ")"));
    }
}

