/*
 * Decompiled with CFR 0.152.
 */
package io.chatpal.solr.ext.handler;

import io.chatpal.solr.ext.DocType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.index.IndexableField;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.SearchHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.DocsStreamer;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatpalSearchRequestHandler
extends SearchHandler {
    private Logger logger = LoggerFactory.getLogger(ChatpalSearchRequestHandler.class);
    private Map<DocType, SolrParams> defaultParams = new EnumMap<DocType, SolrParams>(DocType.class);

    public void init(NamedList args) {
        super.init(args);
        if (args != null) {
            for (DocType docType : DocType.values()) {
                this.defaultParams.put(docType, ChatpalSearchRequestHandler.getSolrParamsFromNamedList((NamedList)args, (String)docType.getKey()));
            }
        }
    }

    public void handleRequestBody(SolrQueryRequest originalReq, SolrQueryResponse rsp) throws Exception {
        this.queryFor(DocType.Message, originalReq, rsp, this::appendACLFilter);
        this.queryFor(DocType.Room, originalReq, rsp, this::appendACLFilter);
        this.queryFor(DocType.User, originalReq, rsp, new QueryAdapter[0]);
    }

    private void queryFor(DocType docType, SolrQueryRequest req, SolrQueryResponse rsp, QueryAdapter ... queryAdapter) throws Exception {
        if (!this.typeFilterAccepts(req, docType)) {
            return;
        }
        ModifiableSolrParams query = new ModifiableSolrParams();
        String language = req.getParams().get("language", "none");
        query.set("q", new String[]{req.getParams().get("text")});
        query.set("sort", new String[]{req.getParams().get("sort")});
        if (docType == DocType.Message) {
            query.set("qf", new String[]{"text^2 text_${lang}^1 decompose_text_${lang}^.5".replaceAll("\\$\\{lang}", language)});
            query.add("hl.fl", new String[]{"text_${lang}".replaceAll("\\$\\{lang}", language)});
            query.set("bf", new String[]{"recip(ms(NOW,updated),3.6e-11,3,1)"});
        }
        query.set("fq", new String[]{this.buildTypeFilter(docType)});
        query.set("start", new String[]{req.getParams().get(this.buildTypeParam(docType, "start"), req.getParams().get("start"))});
        query.set("rows", new String[]{req.getParams().get(this.buildTypeParam(docType, "rows"), req.getParams().get("rows"))});
        for (QueryAdapter adapter : queryAdapter) {
            adapter.adaptQuery(query, req, rsp, docType);
        }
        SolrParams defaultedQuery = SolrParams.wrapDefaults((SolrParams)query, (SolrParams)SolrParams.wrapDefaults((SolrParams)this.defaultParams.get((Object)docType), (SolrParams)this.defaults));
        this.logger.debug("Chatpal query: {}", (Object)defaultedQuery);
        LocalSolrQueryRequest userRequest = new LocalSolrQueryRequest(req.getCore(), defaultedQuery);
        SolrQueryResponse response = new SolrQueryResponse();
        super.handleRequestBody((SolrQueryRequest)userRequest, response);
        rsp.add(docType.getKey(), (Object)this.materializeResult(req.getSchema(), response, language));
    }

    private boolean typeFilterAccepts(SolrQueryRequest req, DocType type) {
        Object[] types = req.getParams().getParams("type[]");
        return ArrayUtils.isEmpty((Object[])types) || ArrayUtils.contains((Object[])types, (Object)type.getKey());
    }

    private NamedList materializeResult(IndexSchema schema, SolrQueryResponse rsp, String language) {
        NamedList facets;
        NamedList result = new NamedList();
        ResultContext rspContext = (ResultContext)rsp.getResponse();
        DocList docList = rspContext.getDocList();
        ArrayList<SolrDocument> docs = new ArrayList<SolrDocument>(docList.size());
        NamedList highlighting = (NamedList)rsp.getValues().get("highlighting");
        DocsStreamer documentIterator = new DocsStreamer(rspContext);
        while (documentIterator.hasNext()) {
            String id;
            NamedList highlights;
            SolrDocument doc = documentIterator.next();
            if (highlighting != null && (highlights = (NamedList)highlighting.get(id = String.valueOf(this.getFirstValue(doc, schema.getUniqueKeyField())))) != null) {
                for (Map.Entry highlight : highlights) {
                    String fieldName = (String)highlight.getKey();
                    Object fieldValue = highlight.getValue();
                    String targetField = StringUtils.removeEnd((String)fieldName, (String)("_" + language));
                    if (!rspContext.getReturnFields().wantsField(targetField)) continue;
                    if (this.isMultiValueFiled(schema, targetField)) {
                        doc.setField(targetField, fieldValue);
                        continue;
                    }
                    if (fieldValue == null) continue;
                    if (fieldValue.getClass().isArray()) {
                        Object firstVal = ((Object[])fieldValue)[0];
                        doc.setField(targetField, firstVal);
                        continue;
                    }
                    if (fieldValue instanceof Collection) {
                        Collection c = (Collection)fieldValue;
                        if (c.size() <= 0) continue;
                        doc.setField(targetField, c.iterator().next());
                        continue;
                    }
                    doc.setField(targetField, fieldValue);
                }
            }
            for (String fName : new HashSet(doc.getFieldNames())) {
                if (rspContext.getReturnFields().wantsField(fName)) continue;
                doc.removeFields(fName);
            }
            docs.add(doc);
        }
        result.add("docs", docs);
        result.add("numFound", (Object)docList.matches());
        result.add("start", (Object)docList.offset());
        if (docList.hasScores()) {
            result.add("maxScore", (Object)Float.valueOf(docList.maxScore()));
        }
        if ((facets = (NamedList)rsp.getValues().get("facet_counts")) != null) {
            result.add("facets", (Object)facets);
        }
        return result;
    }

    private boolean isMultiValueFiled(IndexSchema schema, String fieldName) {
        SchemaField fieldOrNull = schema.getFieldOrNull(fieldName);
        return fieldOrNull == null || fieldOrNull.multiValued();
    }

    private Object getFirstValue(SolrDocument doc, SchemaField field) {
        Object value = doc.getFirstValue(field.getName());
        if (value instanceof IndexableField) {
            return DocsStreamer.getValue((SchemaField)field, (IndexableField)((IndexableField)value));
        }
        return value;
    }

    private String buildTypeParam(DocType message, String param) {
        return message.getKey() + "." + param;
    }

    private String buildTypeFilter(DocType type) {
        return "type:" + type.getIndexVal();
    }

    private void appendACLFilter(ModifiableSolrParams query, SolrQueryRequest req, SolrQueryResponse rsp, DocType docType) {
        query.add("fq", new String[]{this.buildACLFilter(req.getParams())});
    }

    private String buildACLFilter(SolrParams params) {
        return this.buildOrFilter(params, "acl[]", "rid");
    }

    private String buildOrFilter(SolrParams solrParams, String param, String field) {
        String[] values = solrParams.getParams(param);
        if (values == null || values.length < 1) {
            return "-" + field + ":*";
        }
        return "{!q.op=OR}" + field + ":" + Arrays.stream(values).map(ClientUtils::escapeQueryChars).collect(Collectors.joining(" ", "(", ")"));
    }

    private static interface QueryAdapter {
        public void adaptQuery(ModifiableSolrParams var1, SolrQueryRequest var2, SolrQueryResponse var3, DocType var4);
    }
}

