/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.appliers;

import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElementContainer;
import io.camunda.zeebe.engine.state.TypedEventApplier;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableMessageState;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.concurrent.atomic.AtomicLong;
import org.agrona.DirectBuffer;

final class ProcessInstanceElementMigratedV2Applier
implements TypedEventApplier<ProcessInstanceIntent, ProcessInstanceRecord> {
    private final MutableElementInstanceState elementInstanceState;
    private final ProcessState processState;
    private final MutableMessageState messageState;

    public ProcessInstanceElementMigratedV2Applier(MutableElementInstanceState elementInstanceState, ProcessState processState, MutableMessageState messageState) {
        this.elementInstanceState = elementInstanceState;
        this.processState = processState;
        this.messageState = messageState;
    }

    @Override
    public void applyState(long elementInstanceKey, ProcessInstanceRecord value) {
        if (value.getBpmnElementType() == BpmnElementType.PROCESS) {
            this.migrateCorrelatedMessageStartEvent(elementInstanceKey, value);
        }
        AtomicLong previousProcessDefinitionKey = new AtomicLong();
        this.elementInstanceState.updateInstance(elementInstanceKey, elementInstance -> {
            previousProcessDefinitionKey.set(elementInstance.getValue().getProcessDefinitionKey());
            elementInstance.getValue().setProcessDefinitionKey(value.getProcessDefinitionKey()).setBpmnProcessId(value.getBpmnProcessId()).setVersion(value.getVersion()).setElementId(value.getElementId()).setFlowScopeKey(value.getFlowScopeKey());
        });
        if (value.getBpmnElementType() == BpmnElementType.PROCESS) {
            this.elementInstanceState.deleteProcessInstanceKeyByDefinitionKey(value.getProcessInstanceKey(), previousProcessDefinitionKey.get());
            this.elementInstanceState.insertProcessInstanceKeyByDefinitionKey(value.getProcessInstanceKey(), value.getProcessDefinitionKey());
        }
    }

    private void migrateCorrelatedMessageStartEvent(long elementInstanceKey, ProcessInstanceRecord value) {
        boolean hasBpmnProcessIdChanged;
        ProcessInstanceRecord instance = this.elementInstanceState.getInstance(elementInstanceKey).getValue();
        DirectBuffer previousBpmnProcessId = instance.getBpmnProcessIdBuffer();
        DirectBuffer currentBpmnProcessId = value.getBpmnProcessIdBuffer();
        DirectBuffer correlationKey = this.messageState.getProcessInstanceCorrelationKey(value.getProcessInstanceKey());
        if (this.isCorrelationKeyAbsent(correlationKey)) {
            return;
        }
        boolean isTargetWithMessageStartEvent = this.processState.getFlowElement(value.getProcessDefinitionKey(), value.getTenantId(), value.getElementIdBuffer(), ExecutableFlowElementContainer.class).hasMessageStartEvent();
        boolean bl = hasBpmnProcessIdChanged = !BufferUtil.equals((DirectBuffer)previousBpmnProcessId, (DirectBuffer)currentBpmnProcessId);
        if (isTargetWithMessageStartEvent && hasBpmnProcessIdChanged) {
            this.messageState.removeActiveProcessInstance(previousBpmnProcessId, correlationKey);
            this.messageState.putActiveProcessInstance(currentBpmnProcessId, correlationKey);
        }
        if (!isTargetWithMessageStartEvent) {
            this.messageState.removeActiveProcessInstance(previousBpmnProcessId, correlationKey);
            this.messageState.removeProcessInstanceCorrelationKey(value.getProcessInstanceKey());
        }
    }

    private boolean isCorrelationKeyAbsent(DirectBuffer correlationKey) {
        return correlationKey == null || correlationKey.capacity() == 0;
    }
}

