/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.metrics.EngineMetricsDoc;
import io.camunda.zeebe.engine.metrics.JobProcessingMetrics;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobActivationBehavior;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import java.time.InstantSource;

public final class JobTimeOutProcessor
implements TypedRecordProcessor<JobRecord> {
    public static final String NOT_ACTIVATED_JOB_MESSAGE = "Expected to time out activated job with key '%d', but %s";
    private final JobState jobState;
    private final StateWriter stateWriter;
    private final TypedRejectionWriter rejectionWriter;
    private final JobProcessingMetrics jobMetrics;
    private final BpmnJobActivationBehavior jobActivationBehavior;
    private final InstantSource clock;

    public JobTimeOutProcessor(ProcessingState state, Writers writers, JobProcessingMetrics jobMetrics, BpmnJobActivationBehavior jobActivationBehavior, InstantSource clock) {
        this.jobState = state.getJobState();
        this.stateWriter = writers.state();
        this.rejectionWriter = writers.rejection();
        this.jobMetrics = jobMetrics;
        this.jobActivationBehavior = jobActivationBehavior;
        this.clock = clock;
    }

    @Override
    public void processRecord(TypedRecord<JobRecord> record) {
        long jobKey = record.getKey();
        JobRecord job = this.jobState.getJob(jobKey);
        JobState.State state = this.jobState.getState(jobKey);
        if (state == JobState.State.ACTIVATED && this.hasTimedOut(job)) {
            this.stateWriter.appendFollowUpEvent(jobKey, (Intent)JobIntent.TIMED_OUT, (RecordValue)job);
            this.jobMetrics.countJobEvent(EngineMetricsDoc.JobAction.TIMED_OUT, job.getJobKind(), job.getType());
            this.jobActivationBehavior.publishWork(jobKey, job);
        } else {
            String reason = switch (state) {
                default -> throw new MatchException(null, null);
                case JobState.State.ACTIVATED -> "it has not timed out";
                case JobState.State.ACTIVATABLE -> "it must be activated first";
                case JobState.State.FAILED -> "it is marked as failed and is not activated";
                case JobState.State.ERROR_THROWN -> "it has thrown an error and is not activated";
                case JobState.State.NOT_FOUND -> "no such job was found";
            };
            String errorMessage = String.format(NOT_ACTIVATED_JOB_MESSAGE, jobKey, reason);
            this.rejectionWriter.appendRejection(record, RejectionType.NOT_FOUND, errorMessage);
        }
    }

    private boolean hasTimedOut(JobRecord job) {
        return job.getDeadline() < this.clock.millis();
    }
}

