/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.distribution;

import io.camunda.zeebe.engine.processing.distribution.CommandDistributionBehavior;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.protocol.impl.record.value.distribution.CommandDistributionRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.CommandDistributionIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import java.util.Optional;

public class CommandDistributionFinishProcessor
implements TypedRecordProcessor<CommandDistributionRecord> {
    private final CommandDistributionBehavior commandDistributionBehavior;
    private final StateWriter stateWriter;

    public CommandDistributionFinishProcessor(Writers writers, CommandDistributionBehavior commandDistributionBehavior) {
        this.stateWriter = writers.state();
        this.commandDistributionBehavior = commandDistributionBehavior;
    }

    @Override
    public void processRecord(TypedRecord<CommandDistributionRecord> record) {
        CommandDistributionRecord distributionRecord = (CommandDistributionRecord)record.getValue();
        Optional.ofNullable(distributionRecord.getQueueId()).ifPresent(this.commandDistributionBehavior::continueAfterQueue);
        this.stateWriter.appendFollowUpEvent(record.getKey(), (Intent)CommandDistributionIntent.FINISHED, (RecordValue)distributionRecord);
    }
}

