/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.distribution;

import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedEventWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.DistributionState;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.distribution.CommandDistributionRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.CommandDistributionIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.stream.api.records.TypedRecord;

public class CommandDistributionContinueProcessor
implements TypedRecordProcessor<CommandDistributionRecord> {
    private final DistributionState distributionState;
    private final TypedCommandWriter commandWriter;
    private final TypedEventWriter stateWriter;

    public CommandDistributionContinueProcessor(DistributionState distributionState, Writers writers) {
        this.distributionState = distributionState;
        this.commandWriter = writers.command();
        this.stateWriter = writers.state();
    }

    @Override
    public void processRecord(TypedRecord<CommandDistributionRecord> record) {
        long key = record.getKey();
        CommandDistributionRecord distributionRecord = (CommandDistributionRecord)record.getValue();
        String queue = distributionRecord.getQueueId();
        CommandDistributionRecord continuationRecord = this.distributionState.getContinuationRecord(queue, key);
        Intent intent = continuationRecord.getIntent();
        UnifiedRecordValue continuationCommand = continuationRecord.getCommandValue();
        this.commandWriter.appendFollowUpCommand(key, intent, (RecordValue)continuationCommand);
        this.stateWriter.appendFollowUpEvent(key, (Intent)CommandDistributionIntent.CONTINUED, (RecordValue)distributionRecord);
    }
}

