/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer.zeebe;

import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableJobWorkerElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.JobWorkerProperties;
import io.camunda.zeebe.engine.processing.deployment.model.element.LinkedResource;
import io.camunda.zeebe.model.bpmn.instance.FlowElement;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeLinkedResource;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeLinkedResources;
import java.util.List;
import java.util.Optional;

public class LinkedResourcesTransformer {
    public <T extends FlowElement> void transform(ExecutableJobWorkerElement jobWorkerElement, ZeebeLinkedResources linkedResources) {
        if (linkedResources == null) {
            return;
        }
        JobWorkerProperties jobWorkerProperties = Optional.ofNullable(jobWorkerElement.getJobWorkerProperties()).orElse(new JobWorkerProperties());
        jobWorkerElement.setJobWorkerProperties(jobWorkerProperties);
        List<LinkedResource> collected = linkedResources.getLinkedResources().stream().map(this::toLinkedResourceModel).toList();
        jobWorkerProperties.setLinkedResources(collected);
    }

    private LinkedResource toLinkedResourceModel(ZeebeLinkedResource zeebeLinkedResource) {
        LinkedResource linkedResource = new LinkedResource();
        linkedResource.setResourceId(zeebeLinkedResource.getResourceId());
        linkedResource.setLinkName(zeebeLinkedResource.getLinkName());
        linkedResource.setResourceType(zeebeLinkedResource.getResourceType());
        linkedResource.setBindingType(zeebeLinkedResource.getBindingType());
        linkedResource.setVersionTag(zeebeLinkedResource.getVersionTag());
        return linkedResource;
    }
}

