/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment;

import io.camunda.zeebe.engine.EngineConfiguration;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.common.CatchEventBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.StartEventSubscriptionManager;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableStartEvent;
import io.camunda.zeebe.engine.processing.deployment.transform.DeploymentTransformer;
import io.camunda.zeebe.engine.processing.distribution.CommandDistributionBehavior;
import io.camunda.zeebe.engine.processing.streamprocessor.DistributedTypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.DecisionState;
import io.camunda.zeebe.engine.state.immutable.FormState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.immutable.ResourceState;
import io.camunda.zeebe.engine.state.immutable.TimerInstanceState;
import io.camunda.zeebe.engine.state.instance.TimerInstance;
import io.camunda.zeebe.model.bpmn.util.time.Timer;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRequirementsMetadataRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRequirementsRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.FormMetadataRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.FormRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessMetadata;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ResourceMetadataRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ResourceRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.DecisionIntent;
import io.camunda.zeebe.protocol.record.intent.DecisionRequirementsIntent;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.FormIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessIntent;
import io.camunda.zeebe.protocol.record.intent.ResourceIntent;
import io.camunda.zeebe.protocol.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.FeatureFlags;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.time.InstantSource;
import java.util.List;
import java.util.function.Predicate;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class DeploymentCreateProcessor
implements DistributedTypedRecordProcessor<DeploymentRecord> {
    private static final String COULD_NOT_CREATE_TIMER_MESSAGE = "Expected to create timer for start event, but encountered the following error: %s";
    private final DeploymentTransformer deploymentTransformer;
    private final ProcessState processState;
    private final DecisionState decisionState;
    private final FormState formState;
    private final ResourceState resourceState;
    private final TimerInstanceState timerInstanceState;
    private final CatchEventBehavior catchEventBehavior;
    private final KeyGenerator keyGenerator;
    private final ExpressionProcessor expressionProcessor;
    private final StateWriter stateWriter;
    private final StartEventSubscriptionManager startEventSubscriptionManager;
    private final TypedRejectionWriter rejectionWriter;
    private final TypedResponseWriter responseWriter;
    private final CommandDistributionBehavior distributionBehavior;

    public DeploymentCreateProcessor(ProcessingState processingState, BpmnBehaviors bpmnBehaviors, Writers writers, KeyGenerator keyGenerator, FeatureFlags featureFlags, CommandDistributionBehavior distributionBehavior, EngineConfiguration config, InstantSource clock) {
        this.processState = processingState.getProcessState();
        this.decisionState = processingState.getDecisionState();
        this.formState = processingState.getFormState();
        this.resourceState = processingState.getResourceState();
        this.timerInstanceState = processingState.getTimerState();
        this.keyGenerator = keyGenerator;
        this.stateWriter = writers.state();
        this.rejectionWriter = writers.rejection();
        this.responseWriter = writers.response();
        this.catchEventBehavior = bpmnBehaviors.catchEventBehavior();
        this.expressionProcessor = bpmnBehaviors.expressionBehavior();
        this.distributionBehavior = distributionBehavior;
        this.deploymentTransformer = new DeploymentTransformer(this.stateWriter, processingState, this.expressionProcessor, keyGenerator, featureFlags, config, clock);
        this.startEventSubscriptionManager = new StartEventSubscriptionManager(processingState, keyGenerator, this.stateWriter);
    }

    @Override
    public void processNewCommand(TypedRecord<DeploymentRecord> command) {
        this.transformAndDistributeDeployment(command);
        this.startEventSubscriptionManager.tryReOpenStartEventSubscription((DeploymentRecord)command.getValue());
    }

    @Override
    public void processDistributedCommand(TypedRecord<DeploymentRecord> command) {
        this.processDistributedRecord(command);
        this.startEventSubscriptionManager.tryReOpenStartEventSubscription((DeploymentRecord)command.getValue());
    }

    @Override
    public TypedRecordProcessor.ProcessingError tryHandleError(TypedRecord<DeploymentRecord> command, Throwable error) {
        if (((DeploymentRecord)command.getValue()).hasBpmnResources()) {
            this.processState.clearCache();
        }
        if (((DeploymentRecord)command.getValue()).hasDmnResources()) {
            this.decisionState.clearCache();
        }
        if (((DeploymentRecord)command.getValue()).hasForms()) {
            this.formState.clearCache();
        }
        if (((DeploymentRecord)command.getValue()).hasResources()) {
            this.resourceState.clearCache();
        }
        if (error instanceof ResourceTransformationFailedException) {
            ResourceTransformationFailedException exception = (ResourceTransformationFailedException)error;
            this.rejectionWriter.appendRejection(command, RejectionType.INVALID_ARGUMENT, exception.getMessage());
            this.responseWriter.writeRejectionOnCommand(command, RejectionType.INVALID_ARGUMENT, exception.getMessage());
            return TypedRecordProcessor.ProcessingError.EXPECTED_ERROR;
        }
        if (error instanceof TimerCreationFailedException) {
            TimerCreationFailedException exception = (TimerCreationFailedException)error;
            this.rejectionWriter.appendRejection(command, RejectionType.PROCESSING_ERROR, exception.getMessage());
            this.responseWriter.writeRejectionOnCommand(command, RejectionType.PROCESSING_ERROR, exception.getMessage());
            return TypedRecordProcessor.ProcessingError.EXPECTED_ERROR;
        }
        return TypedRecordProcessor.ProcessingError.UNEXPECTED_ERROR;
    }

    private void transformAndDistributeDeployment(TypedRecord<DeploymentRecord> command) {
        DeploymentRecord deploymentEvent = (DeploymentRecord)command.getValue();
        long key = this.keyGenerator.nextKey();
        deploymentEvent.setDeploymentKey(key);
        Either<Failure, Void> result = this.deploymentTransformer.transform(deploymentEvent);
        if (result.isLeft()) {
            throw new ResourceTransformationFailedException(((Failure)result.getLeft()).getMessage());
        }
        try {
            this.createTimerIfTimerStartEvent(command);
        }
        catch (RuntimeException e) {
            String reason = String.format(COULD_NOT_CREATE_TIMER_MESSAGE, e.getMessage());
            throw new TimerCreationFailedException(reason);
        }
        DeploymentRecord recordWithoutResource = this.createDeploymentWithoutResources(deploymentEvent);
        this.responseWriter.writeEventOnCommand(key, (Intent)DeploymentIntent.CREATED, (UnpackedObject)recordWithoutResource, command);
        this.stateWriter.appendFollowUpEvent(key, (Intent)DeploymentIntent.CREATED, (RecordValue)recordWithoutResource);
        this.distributionBehavior.withKey(key).unordered().distribute(command);
    }

    private void processDistributedRecord(TypedRecord<DeploymentRecord> command) {
        DeploymentRecord deploymentEvent = (DeploymentRecord)command.getValue();
        this.createBpmnResources(deploymentEvent);
        this.createDmnResources(deploymentEvent);
        this.createFormResources(deploymentEvent);
        this.createResources(deploymentEvent);
        DeploymentRecord recordWithoutResource = this.createDeploymentWithoutResources(deploymentEvent);
        this.stateWriter.appendFollowUpEvent(command.getKey(), (Intent)DeploymentIntent.CREATED, (RecordValue)recordWithoutResource);
        this.distributionBehavior.acknowledgeCommand(command);
    }

    private void createBpmnResources(DeploymentRecord deploymentEvent) {
        deploymentEvent.processesMetadata().stream().filter(Predicate.not(ProcessMetadata::isDuplicate)).forEach(metadata -> {
            for (DeploymentResource resource : deploymentEvent.getResources()) {
                DirectBuffer resourceChecksum = this.deploymentTransformer.getChecksum(resource.getResource());
                if (!resourceChecksum.equals((Object)metadata.getChecksumBuffer())) continue;
                this.stateWriter.appendFollowUpEvent(metadata.getKey(), (Intent)ProcessIntent.CREATED, (RecordValue)new ProcessRecord().wrap(metadata, resource.getResource()));
            }
        });
    }

    private void createDmnResources(DeploymentRecord deploymentEvent) {
        deploymentEvent.decisionRequirementsMetadata().stream().filter(Predicate.not(DecisionRequirementsMetadataRecord::isDuplicate)).map(drg -> this.createDrgRecord(deploymentEvent, (DecisionRequirementsMetadataRecord)drg)).forEach(decisionRequirementsRecord -> this.stateWriter.appendFollowUpEvent(decisionRequirementsRecord.getDecisionRequirementsKey(), (Intent)DecisionRequirementsIntent.CREATED, (RecordValue)decisionRequirementsRecord));
        deploymentEvent.decisionsMetadata().stream().filter(Predicate.not(DecisionRecord::isDuplicate)).forEach(record -> this.stateWriter.appendFollowUpEvent(record.getDecisionKey(), (Intent)DecisionIntent.CREATED, (RecordValue)record));
    }

    private void createFormResources(DeploymentRecord deploymentEvent) {
        deploymentEvent.formMetadata().stream().filter(Predicate.not(FormMetadataRecord::isDuplicate)).forEach(metadata -> {
            for (DeploymentResource resource : deploymentEvent.getResources()) {
                DirectBuffer resourceChecksum = this.deploymentTransformer.getChecksum(resource.getResource());
                if (!resourceChecksum.equals((Object)metadata.getChecksumBuffer())) continue;
                this.stateWriter.appendFollowUpEvent(metadata.getFormKey(), (Intent)FormIntent.CREATED, (RecordValue)new FormRecord().wrap(metadata, resource.getResource()));
            }
        });
    }

    private void createResources(DeploymentRecord deploymentEvent) {
        deploymentEvent.resourceMetadata().stream().filter(Predicate.not(ResourceMetadataRecord::isDuplicate)).forEach(metadata -> {
            for (DeploymentResource resource : deploymentEvent.getResources()) {
                DirectBuffer resourceChecksum = this.deploymentTransformer.getChecksum(resource.getResource());
                if (!resourceChecksum.equals((Object)metadata.getChecksumBuffer())) continue;
                this.stateWriter.appendFollowUpEvent(metadata.getResourceKey(), (Intent)ResourceIntent.CREATED, (RecordValue)new ResourceRecord().wrap(metadata, resource.getResource()));
            }
        });
    }

    private DeploymentRecord createDeploymentWithoutResources(DeploymentRecord deploymentEvent) {
        DeploymentRecord copyRecord = new DeploymentRecord();
        copyRecord.wrap(BufferUtil.createCopy((BufferWriter)deploymentEvent));
        copyRecord.resetResources();
        return copyRecord;
    }

    private void createTimerIfTimerStartEvent(TypedRecord<DeploymentRecord> record) {
        for (ProcessMetadata processMetadata : ((DeploymentRecord)record.getValue()).processesMetadata()) {
            if (processMetadata.isDuplicate()) continue;
            List<ExecutableStartEvent> startEvents = this.processState.getProcessByKeyAndTenant(processMetadata.getKey(), processMetadata.getTenantId()).getProcess().getStartEvents();
            this.unsubscribeFromPreviousTimers(processMetadata);
            this.subscribeToTimerStartEventIfExists(processMetadata, startEvents);
        }
    }

    private void subscribeToTimerStartEventIfExists(ProcessMetadata processMetadata, List<ExecutableStartEvent> startEvents) {
        for (ExecutableCatchEventElement executableCatchEventElement : startEvents) {
            if (!executableCatchEventElement.isTimer()) continue;
            long scopeKey = -1L;
            Either<Failure, Timer> timerOrError = executableCatchEventElement.getTimerFactory().apply(this.expressionProcessor, -1L);
            if (timerOrError.isLeft()) {
                throw new ExpressionProcessor.EvaluationException(((Failure)timerOrError.getLeft()).getMessage());
            }
            this.catchEventBehavior.subscribeToTimerEvent(-1L, -1L, processMetadata.getKey(), executableCatchEventElement.getId(), processMetadata.getTenantId(), (Timer)timerOrError.get());
        }
    }

    private void unsubscribeFromPreviousTimers(ProcessMetadata processRecord) {
        this.timerInstanceState.forEachTimerForElementInstance(-1L, timer -> this.unsubscribeFromPreviousTimer(processRecord, (TimerInstance)((Object)timer)));
    }

    private void unsubscribeFromPreviousTimer(ProcessMetadata processMetadata, TimerInstance timer) {
        DirectBuffer timerBpmnId = this.processState.getProcessByKeyAndTenant(timer.getProcessDefinitionKey(), timer.getTenantId()).getBpmnProcessId();
        if (timerBpmnId.equals((Object)processMetadata.getBpmnProcessIdBuffer()) && timer.getTenantId().equals(processMetadata.getTenantId())) {
            this.catchEventBehavior.unsubscribeFromTimerEvent(timer);
        }
    }

    private DecisionRequirementsRecord createDrgRecord(DeploymentRecord deploymentEvent, DecisionRequirementsMetadataRecord drg) {
        MutableDirectBuffer resource = deploymentEvent.getResources().stream().filter(r -> r.getResourceName().equals(drg.getResourceName())).map(DeploymentResource::getResource).map(BufferUtil::wrapArray).findFirst().orElseThrow(() -> new NoSuchResourceException(drg.getResourceName()));
        return new DecisionRequirementsRecord().setDecisionRequirementsKey(drg.getDecisionRequirementsKey()).setDecisionRequirementsId(drg.getDecisionRequirementsId()).setDecisionRequirementsVersion(drg.getDecisionRequirementsVersion()).setDecisionRequirementsName(drg.getDecisionRequirementsName()).setNamespace(drg.getNamespace()).setResourceName(drg.getResourceName()).setChecksum((DirectBuffer)BufferUtil.wrapArray((byte[])drg.getChecksum())).setResource((DirectBuffer)resource).setTenantId(drg.getTenantId());
    }

    private static final class ResourceTransformationFailedException
    extends RuntimeException {
        private ResourceTransformationFailedException(String message) {
            super(message);
        }
    }

    private static final class TimerCreationFailedException
    extends RuntimeException {
        public TimerCreationFailedException(String message) {
            super(message);
        }
    }

    private static final class NoSuchResourceException
    extends IllegalStateException {
        private NoSuchResourceException(String resourceName) {
            super(String.format("Expected to find resource '%s' in deployment but not found", resourceName));
        }
    }
}

