/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.common;

import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCallActivity;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class ElementTreePathBuilder {
    private ElementInstanceState elementInstanceState;
    private ProcessState processState;
    private Long elementInstanceKey;
    private ElementTreePathProperties properties;

    public ElementTreePathBuilder withElementInstanceState(ElementInstanceState elementInstanceState) {
        this.elementInstanceState = elementInstanceState;
        return this;
    }

    public ElementTreePathBuilder withProcessState(ProcessState processState) {
        this.processState = processState;
        return this;
    }

    public ElementTreePathBuilder withElementInstanceKey(long elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
        return this;
    }

    public ElementTreePathProperties build() {
        Objects.requireNonNull(this.elementInstanceState, "elementInstanceState cannot be null");
        Objects.requireNonNull(this.processState, "processState cannot be null");
        Objects.requireNonNull(this.elementInstanceKey, "elementInstanceKey cannot be null");
        this.properties = new ElementTreePathProperties(new LinkedList<List<Long>>(), new LinkedList<Long>(), new LinkedList<Integer>());
        this.buildElementTreePathProperties(this.elementInstanceKey);
        return this.properties;
    }

    private void buildElementTreePathProperties(long elementInstanceKey) {
        ElementInstance elementInstance = this.getElementInstance(elementInstanceKey);
        long parentElementInstanceKey = elementInstance.getParentKey();
        ElementProperties elementProperties = new ElementProperties(elementInstanceKey, parentElementInstanceKey, (ProcessInstanceRecordValue)elementInstance.getValue());
        this.buildElementTreePathProperties(elementProperties);
    }

    private void buildElementTreePathProperties(ElementProperties elementProperties) {
        LinkedList<ElementProperties> elementQueue = new LinkedList<ElementProperties>();
        elementQueue.offer(elementProperties);
        while (!elementQueue.isEmpty()) {
            ElementProperties curr = (ElementProperties)elementQueue.poll();
            ProcessInstanceRecordValue processInstanceRecord = curr.processInstanceRecord;
            LinkedList<Long> elementInstancePath = new LinkedList<Long>();
            elementInstancePath.add(curr.elementInstanceKey);
            long currParent = curr.parentElementInstanceKey;
            while (currParent != -1L) {
                elementInstancePath.addFirst(currParent);
                ElementInstance instance = this.getElementInstance(currParent);
                processInstanceRecord = instance.getValue();
                currParent = instance.getParentKey();
            }
            this.properties.elementInstancePath.addFirst(elementInstancePath);
            this.properties.processDefinitionPath.addFirst(processInstanceRecord.getProcessDefinitionKey());
            long callingElementInstanceKey = processInstanceRecord.getParentElementInstanceKey();
            if (callingElementInstanceKey == -1L) continue;
            this.properties.callingElementPath.addFirst(this.getCallActivityIndex(callingElementInstanceKey));
            ElementInstance callingInstance = this.getElementInstance(callingElementInstanceKey);
            elementQueue.offer(new ElementProperties(callingElementInstanceKey, callingInstance.getParentKey(), (ProcessInstanceRecordValue)callingInstance.getValue()));
        }
    }

    private Integer getCallActivityIndex(long callingElementInstanceKey) {
        ElementInstance callActivityElementInstance = this.getElementInstance(callingElementInstanceKey);
        ProcessInstanceRecord callActivityInstanceRecord = callActivityElementInstance.getValue();
        ExecutableCallActivity callActivity = this.processState.getFlowElement(callActivityInstanceRecord.getProcessDefinitionKey(), callActivityInstanceRecord.getTenantId(), callActivityInstanceRecord.getElementIdBuffer(), ExecutableCallActivity.class);
        return callActivity.getLexicographicIndex();
    }

    private ElementInstance getElementInstance(long elementInstanceKey) {
        ElementInstance instance = this.elementInstanceState.getInstance(elementInstanceKey);
        if (instance == null) {
            throw new IllegalStateException(String.format("Expected to find element instance for given key '%d', but didn't exist.", elementInstanceKey));
        }
        return instance;
    }

    public record ElementTreePathProperties(List<List<Long>> elementInstancePath, List<Long> processDefinitionPath, List<Integer> callingElementPath) {
    }

    private record ElementProperties(Long elementInstanceKey, Long parentElementInstanceKey, ProcessInstanceRecordValue processInstanceRecord) {
    }
}

