/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.behavior;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.HeaderEncoder;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableUserTask;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.deployment.PersistedForm;
import io.camunda.zeebe.engine.state.immutable.FormState;
import io.camunda.zeebe.engine.state.immutable.UserTaskState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.mutable.MutableUserTaskState;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeBindingType;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebePriorityDefinition;
import io.camunda.zeebe.model.bpmn.validation.zeebe.ZeebePriorityDefinitionValidator;
import io.camunda.zeebe.msgpack.value.DocumentValue;
import io.camunda.zeebe.protocol.impl.record.value.usertask.UserTaskRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.UserTaskIntent;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.util.Either;
import java.time.InstantSource;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.agrona.DirectBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BpmnUserTaskBehavior {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BpmnUserTaskBehavior.class.getPackageName());
    private static final Set<UserTaskState.LifecycleState> CANCELABLE_LIFECYCLE_STATES = EnumSet.complementOf(EnumSet.of(UserTaskState.LifecycleState.NOT_FOUND, UserTaskState.LifecycleState.CANCELING));
    private final UserTaskRecord userTaskRecord = new UserTaskRecord().setVariables(DocumentValue.EMPTY_DOCUMENT);
    private final HeaderEncoder headerEncoder = new HeaderEncoder(LOGGER);
    private final KeyGenerator keyGenerator;
    private final StateWriter stateWriter;
    private final ExpressionProcessor expressionBehavior;
    private final BpmnStateBehavior stateBehavior;
    private final FormState formState;
    private final MutableUserTaskState userTaskState;
    private final InstantSource clock;

    public BpmnUserTaskBehavior(KeyGenerator keyGenerator, Writers writers, ExpressionProcessor expressionBehavior, BpmnStateBehavior stateBehavior, FormState formState, MutableUserTaskState userTaskState, InstantSource clock) {
        this.keyGenerator = keyGenerator;
        this.stateWriter = writers.state();
        this.expressionBehavior = expressionBehavior;
        this.stateBehavior = stateBehavior;
        this.formState = formState;
        this.userTaskState = userTaskState;
        this.clock = clock;
    }

    public Either<Failure, UserTaskProperties> evaluateUserTaskExpressions(ExecutableUserTask element, BpmnElementContext context) {
        io.camunda.zeebe.engine.processing.deployment.model.element.UserTaskProperties userTaskProps = element.getUserTaskProperties();
        long scopeKey = context.getElementInstanceKey();
        return Either.right((Object)new UserTaskProperties()).flatMap(p -> this.evaluateAssigneeExpression(userTaskProps.getAssignee(), scopeKey).map(p::assignee)).flatMap(p -> this.evaluateCandidateGroupsExpression(userTaskProps.getCandidateGroups(), scopeKey).map(p::candidateGroups)).flatMap(p -> this.evaluateCandidateUsersExpression(userTaskProps.getCandidateUsers(), scopeKey).map(p::candidateUsers)).flatMap(p -> this.evaluateDateExpression(userTaskProps.getDueDate(), scopeKey).map(p::dueDate)).flatMap(p -> this.evaluateDateExpression(userTaskProps.getFollowUpDate(), scopeKey).map(p::followUpDate)).flatMap(p -> this.evaluateFormIdExpressionToFormKey(userTaskProps.getFormId(), userTaskProps.getFormBindingType(), userTaskProps.getFormVersionTag(), context, scopeKey).map(p::formKey)).flatMap(p -> this.evaluateExternalFormReferenceExpression(userTaskProps.getExternalFormReference(), scopeKey).map(p::externalFormReference)).flatMap(p -> this.evaluatePriorityExpression(userTaskProps.getPriority(), scopeKey).map(p::priority));
    }

    public UserTaskRecord createNewUserTask(BpmnElementContext context, ExecutableUserTask element, UserTaskProperties userTaskProperties) {
        long userTaskKey = this.keyGenerator.nextKey();
        DirectBuffer encodedHeaders = this.headerEncoder.encode(element.getUserTaskProperties().getTaskHeaders());
        this.userTaskRecord.setUserTaskKey(userTaskKey).setAssignee(userTaskProperties.getAssignee()).setCandidateGroupsList(userTaskProperties.getCandidateGroups()).setCandidateUsersList(userTaskProperties.getCandidateUsers()).setDueDate(userTaskProperties.getDueDate()).setFollowUpDate(userTaskProperties.getFollowUpDate()).setFormKey(userTaskProperties.getFormKey().longValue()).setExternalFormReference(userTaskProperties.getExternalFormReference()).setCustomHeaders(encodedHeaders).setBpmnProcessId(context.getBpmnProcessId()).setProcessDefinitionVersion(context.getProcessVersion()).setProcessDefinitionKey(context.getProcessDefinitionKey()).setProcessInstanceKey(context.getProcessInstanceKey()).setElementId(element.getId()).setElementInstanceKey(context.getElementInstanceKey()).setTenantId(context.getTenantId()).setPriority(userTaskProperties.getPriority().intValue()).setCreationTimestamp(this.clock.millis());
        this.stateWriter.appendFollowUpEvent(userTaskKey, (Intent)UserTaskIntent.CREATING, (RecordValue)this.userTaskRecord);
        return this.userTaskRecord;
    }

    public Either<Failure, String> evaluateAssigneeExpression(Expression assignee, long scopeKey) {
        if (assignee == null) {
            return Either.right(null);
        }
        return this.expressionBehavior.evaluateStringExpression(assignee, scopeKey);
    }

    public Either<Failure, List<String>> evaluateCandidateGroupsExpression(Expression candidateGroups, long scopeKey) {
        if (candidateGroups == null) {
            return Either.right(null);
        }
        return this.expressionBehavior.evaluateArrayOfStringsExpression(candidateGroups, scopeKey);
    }

    public Either<Failure, List<String>> evaluateCandidateUsersExpression(Expression candidateUsers, long scopeKey) {
        if (candidateUsers == null) {
            return Either.right(null);
        }
        return this.expressionBehavior.evaluateArrayOfStringsExpression(candidateUsers, scopeKey);
    }

    public Either<Failure, String> evaluateDateExpression(Expression date, long scopeKey) {
        if (date == null) {
            return Either.right(null);
        }
        return this.expressionBehavior.evaluateDateTimeExpression(date, scopeKey, true).map(optionalDate -> optionalDate.map(ZonedDateTime::toString).orElse(null));
    }

    public Either<Failure, Long> evaluateFormIdExpressionToFormKey(Expression formIdExpression, ZeebeBindingType bindingType, String versionTag, BpmnElementContext context, long scopeKey) {
        if (formIdExpression == null) {
            return Either.right(null);
        }
        return this.expressionBehavior.evaluateStringExpression(formIdExpression, scopeKey).flatMap(formId -> {
            Either<Failure, PersistedForm> form = this.findLinkedForm((String)formId, bindingType, versionTag, context, scopeKey);
            return form.map(PersistedForm::getFormKey);
        });
    }

    private Either<Failure, PersistedForm> findLinkedForm(String formId, ZeebeBindingType bindingType, String versionTag, BpmnElementContext context, long scopeKey) {
        return switch (bindingType) {
            default -> throw new MatchException(null, null);
            case ZeebeBindingType.deployment -> this.findFormByIdInSameDeployment(formId, context, scopeKey);
            case ZeebeBindingType.latest -> this.findLatestFormById(formId, context.getTenantId(), scopeKey);
            case ZeebeBindingType.versionTag -> this.findFormByIdAndVersionTag(formId, versionTag, context.getTenantId(), scopeKey);
        };
    }

    private Either<Failure, PersistedForm> findFormByIdInSameDeployment(String formId, BpmnElementContext context, long scopeKey) {
        return this.stateBehavior.getDeploymentKey(context.getProcessDefinitionKey(), context.getTenantId()).flatMap(deploymentKey -> this.formState.findFormByIdAndDeploymentKey(formId, (long)deploymentKey, context.getTenantId()).map(Either::right).orElseGet(() -> Either.left((Object)new Failure(String.format("Expected to use a form with id '%s' with binding type 'deployment', but no such form found in the deployment with key %s which contained the current process. To resolve this incident, migrate the process instance to a process definition that is deployed together with the intended form to use.", formId, deploymentKey), ErrorType.FORM_NOT_FOUND, scopeKey))));
    }

    private Either<Failure, PersistedForm> findLatestFormById(String formId, String tenantId, long scopeKey) {
        return this.formState.findLatestFormById(formId, tenantId).map(Either::right).orElseGet(() -> Either.left((Object)new Failure(String.format("Expected to find a form with id '%s', but no form with this id is found, at least a form with this id should be available. To resolve the Incident please deploy a form with the same id", formId), ErrorType.FORM_NOT_FOUND, scopeKey)));
    }

    private Either<Failure, PersistedForm> findFormByIdAndVersionTag(String formId, String versionTag, String tenantId, long scopeKey) {
        return this.formState.findFormByIdAndVersionTag(formId, versionTag, tenantId).map(Either::right).orElseGet(() -> Either.left((Object)new Failure(String.format("Expected to use a form with id '%s' and version tag '%s', but no such form found. To resolve the incident, deploy a form with the given id and version tag.\n", formId, versionTag), ErrorType.FORM_NOT_FOUND, scopeKey)));
    }

    public Either<Failure, String> evaluateExternalFormReferenceExpression(Expression externalFormReference, long scopeKey) {
        if (externalFormReference == null) {
            return Either.right(null);
        }
        return this.expressionBehavior.evaluateStringExpression(externalFormReference, scopeKey);
    }

    public Either<Failure, Integer> evaluatePriorityExpression(Expression priorityExpression, long scopeKey) {
        if (priorityExpression == null) {
            return Either.right((Object)ZeebePriorityDefinition.DEFAULT_NUMBER_PRIORITY);
        }
        return this.expressionBehavior.evaluateIntegerExpression(priorityExpression, scopeKey).flatMap(priority -> {
            if (priority < ZeebePriorityDefinitionValidator.PRIORITY_LOWER_BOUND || priority > ZeebePriorityDefinitionValidator.PRIORITY_UPPER_BOUND) {
                return Either.left((Object)new Failure(String.format("Expected priority to be in the range [0,100] but was '%s'.", priority), ErrorType.EXTRACT_VALUE_ERROR, scopeKey));
            }
            return Either.right((Object)priority);
        });
    }

    public void cancelUserTask(BpmnElementContext context) {
        ElementInstance elementInstance = this.stateBehavior.getElementInstance(context);
        this.cancelUserTask(elementInstance);
    }

    public void cancelUserTask(ElementInstance elementInstance) {
        UserTaskState.LifecycleState lifecycleState;
        long userTaskKey = elementInstance.getUserTaskKey();
        if (userTaskKey > 0L && CANCELABLE_LIFECYCLE_STATES.contains((Object)(lifecycleState = this.userTaskState.getLifecycleState(userTaskKey)))) {
            UserTaskRecord userTask = this.userTaskState.getUserTask(userTaskKey);
            this.stateWriter.appendFollowUpEvent(userTaskKey, (Intent)UserTaskIntent.CANCELING, (RecordValue)userTask);
            this.stateWriter.appendFollowUpEvent(userTaskKey, (Intent)UserTaskIntent.CANCELED, (RecordValue)userTask);
        }
    }

    public void userTaskCreated(UserTaskRecord userTaskRecord) {
        long userTaskKey = userTaskRecord.getUserTaskKey();
        this.stateWriter.appendFollowUpEvent(userTaskKey, (Intent)UserTaskIntent.CREATED, (RecordValue)userTaskRecord);
    }

    public static final class UserTaskProperties {
        private String assignee;
        private List<String> candidateGroups;
        private List<String> candidateUsers;
        private String dueDate;
        private String externalFormReference;
        private String followUpDate;
        private Long formKey;
        private Integer priority;

        public String getAssignee() {
            return UserTaskProperties.getOrEmpty(this.assignee);
        }

        public UserTaskProperties assignee(String assignee) {
            this.assignee = assignee;
            return this;
        }

        public List<String> getCandidateGroups() {
            return UserTaskProperties.getOrEmpty(this.candidateGroups);
        }

        public UserTaskProperties candidateGroups(List<String> candidateGroups) {
            this.candidateGroups = candidateGroups;
            return this;
        }

        public List<String> getCandidateUsers() {
            return UserTaskProperties.getOrEmpty(this.candidateUsers);
        }

        public UserTaskProperties candidateUsers(List<String> candidateUsers) {
            this.candidateUsers = candidateUsers;
            return this;
        }

        public String getDueDate() {
            return UserTaskProperties.getOrEmpty(this.dueDate);
        }

        public UserTaskProperties dueDate(String dueDate) {
            this.dueDate = dueDate;
            return this;
        }

        public String getExternalFormReference() {
            return UserTaskProperties.getOrEmpty(this.externalFormReference);
        }

        public UserTaskProperties externalFormReference(String externalFormReference) {
            this.externalFormReference = externalFormReference;
            return this;
        }

        public String getFollowUpDate() {
            return UserTaskProperties.getOrEmpty(this.followUpDate);
        }

        public UserTaskProperties followUpDate(String followUpDate) {
            this.followUpDate = followUpDate;
            return this;
        }

        public Long getFormKey() {
            return this.formKey == null ? -1L : this.formKey;
        }

        public UserTaskProperties formKey(Long formKey) {
            this.formKey = formKey;
            return this;
        }

        public Integer getPriority() {
            return this.priority == null ? ZeebePriorityDefinition.DEFAULT_NUMBER_PRIORITY : this.priority;
        }

        public UserTaskProperties priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        private static String getOrEmpty(String stringValue) {
            return stringValue == null ? "" : stringValue;
        }

        private static List<String> getOrEmpty(List<String> listValue) {
            return listValue == null ? Collections.emptyList() : listValue;
        }
    }
}

