/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn;

import io.camunda.zeebe.engine.EngineConfiguration;
import io.camunda.zeebe.engine.Loggers;
import io.camunda.zeebe.engine.metrics.ProcessEngineMetrics;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContainerProcessor;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContextImpl;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementProcessors;
import io.camunda.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.camunda.zeebe.engine.processing.bpmn.ProcessInstanceStateTransitionGuard;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.common.EventTriggerBehavior;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowNode;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutionListener;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.processing.variable.VariableBehavior;
import io.camunda.zeebe.engine.state.immutable.EventScopeInstanceState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.stream.api.records.ExceededBatchRecordSizeException;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.slf4j.Logger;

public final class BpmnStreamProcessor
implements TypedRecordProcessor<ProcessInstanceRecord> {
    private static final Logger LOGGER = Loggers.PROCESS_PROCESSOR_LOGGER;
    private final BpmnElementContextImpl context = new BpmnElementContextImpl();
    private final ProcessState processState;
    private final BpmnElementProcessors processors;
    private final ProcessInstanceStateTransitionGuard stateTransitionGuard;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final TypedRejectionWriter rejectionWriter;
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnStateBehavior stateBehavior;
    private final BpmnJobBehavior jobBehavior;
    private final EventTriggerBehavior eventTriggerBehavior;
    private final VariableBehavior variableBehavior;
    private final EventScopeInstanceState eventScopeInstanceState;

    public BpmnStreamProcessor(BpmnBehaviors bpmnBehaviors, MutableProcessingState processingState, Writers writers, ProcessEngineMetrics processEngineMetrics, EngineConfiguration config) {
        this.processState = processingState.getProcessState();
        this.rejectionWriter = writers.rejection();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
        this.stateTransitionGuard = bpmnBehaviors.stateTransitionGuard();
        this.stateTransitionBehavior = new BpmnStateTransitionBehavior(processingState.getKeyGenerator(), bpmnBehaviors.stateBehavior(), processEngineMetrics, this::getContainerProcessor, writers);
        this.processors = new BpmnElementProcessors(bpmnBehaviors, this.stateTransitionBehavior, config);
        this.stateBehavior = bpmnBehaviors.stateBehavior();
        this.jobBehavior = bpmnBehaviors.jobBehavior();
        this.eventTriggerBehavior = bpmnBehaviors.eventTriggerBehavior();
        this.variableBehavior = bpmnBehaviors.variableBehavior();
        this.eventScopeInstanceState = processingState.getEventScopeInstanceState();
    }

    private BpmnElementContainerProcessor<ExecutableFlowElement> getContainerProcessor(BpmnElementType elementType) {
        return this.processors.getContainerProcessor(elementType);
    }

    @Override
    public void processRecord(TypedRecord<ProcessInstanceRecord> record) {
        ProcessInstanceIntent intent = (ProcessInstanceIntent)record.getIntent();
        ProcessInstanceRecord recordValue = (ProcessInstanceRecord)record.getValue();
        this.context.init(record.getKey(), recordValue, intent);
        BpmnElementType bpmnElementType = recordValue.getBpmnElementType();
        BpmnElementProcessor<ExecutableFlowElement> processor = this.processors.getProcessor(bpmnElementType);
        ExecutableFlowElement element = this.getElement(recordValue, processor);
        this.stateTransitionGuard.isValidStateTransition(this.context, element).ifRightOrLeft(ok -> {
            LOGGER.trace("Process process instance event [context: {}]", (Object)this.context);
            this.processEvent(intent, processor, element);
        }, violation -> this.rejectionWriter.appendRejection((TypedRecord<? extends RecordValue>)record, RejectionType.INVALID_STATE, violation.getMessage()));
    }

    @Override
    public TypedRecordProcessor.ProcessingError tryHandleError(TypedRecord<ProcessInstanceRecord> command, Throwable error) {
        if (error instanceof ExceededBatchRecordSizeException) {
            this.context.init(command.getKey(), (ProcessInstanceRecord)command.getValue(), (ProcessInstanceIntent)command.getIntent());
            if (this.context.getBpmnElementType() != BpmnElementType.PROCESS) {
                BpmnElementContextImpl transitionedContext = switch ((ProcessInstanceIntent)command.getIntent()) {
                    case ProcessInstanceIntent.ACTIVATE_ELEMENT -> this.stateTransitionBehavior.transitionToActivating(this.context);
                    case ProcessInstanceIntent.COMPLETE_ELEMENT -> this.stateTransitionBehavior.transitionToCompleting(this.context);
                    case ProcessInstanceIntent.TERMINATE_ELEMENT -> this.stateTransitionBehavior.transitionToTerminating(this.context);
                    default -> this.context;
                };
                this.incidentBehavior.createIncident(new Failure("Expected to process element '%s', but exceeded MAX_MESSAGE_SIZE limitation. If you have large or many variables consider reducing these.".formatted(BufferUtil.bufferAsString((DirectBuffer)transitionedContext.getElementId())), ErrorType.MESSAGE_SIZE_EXCEEDED), transitionedContext);
                return TypedRecordProcessor.ProcessingError.EXPECTED_ERROR;
            }
        }
        return TypedRecordProcessor.ProcessingError.UNEXPECTED_ERROR;
    }

    private void processEvent(ProcessInstanceIntent intent, BpmnElementProcessor<ExecutableFlowElement> processor, ExecutableFlowElement element) {
        block0 : switch (intent) {
            case ACTIVATE_ELEMENT: {
                BpmnElementContext activatingContext = this.stateTransitionBehavior.transitionToActivating(this.context);
                this.stateTransitionBehavior.onElementActivating(element, activatingContext).flatMap(ok -> processor.onActivate(element, activatingContext)).flatMap(ok -> this.afterActivating(element, processor, activatingContext)).ifLeft(failure -> this.incidentBehavior.createIncident((Failure)failure, activatingContext));
                break;
            }
            case COMPLETE_ELEMENT: {
                BpmnElementContext completingContext = this.stateTransitionBehavior.transitionToCompleting(this.context);
                processor.onComplete(element, completingContext).flatMap(ok -> this.afterCompleting(element, processor, completingContext)).ifLeft(failure -> this.incidentBehavior.createIncident((Failure)failure, completingContext));
                break;
            }
            case TERMINATE_ELEMENT: {
                BpmnElementContext terminatingContext = this.stateTransitionBehavior.transitionToTerminating(this.context);
                processor.onTerminate(element, terminatingContext);
                break;
            }
            case COMPLETE_EXECUTION_LISTENER: {
                ProcessInstanceIntent elementState = this.stateBehavior.getElementInstance(this.context).getState();
                switch (elementState) {
                    case ELEMENT_ACTIVATING: {
                        this.onStartExecutionListenerComplete((ExecutableFlowNode)element, processor, this.context).ifLeft(failure -> this.incidentBehavior.createIncident((Failure)failure, this.context));
                        break block0;
                    }
                    case ELEMENT_COMPLETING: {
                        this.onEndExecutionListenerComplete((ExecutableFlowNode)element, processor, this.context).ifLeft(failure -> this.incidentBehavior.createIncident((Failure)failure, this.context));
                        break block0;
                    }
                }
                throw new BpmnProcessingException(this.context, String.format("Unexpected element state: '%s'", elementState));
            }
            default: {
                throw new BpmnProcessingException(this.context, String.format("Expected the processor '%s' to handle the event but the intent '%s' is not supported", processor.getClass(), intent));
            }
        }
    }

    private Either<Failure, ?> afterActivating(ExecutableFlowElement element, BpmnElementProcessor<ExecutableFlowElement> processor, BpmnElementContext context) {
        return this.processElementWithListeners(element, context, ExecutableFlowNode::getStartExecutionListeners, processor::finalizeActivation);
    }

    private Either<Failure, ?> afterCompleting(ExecutableFlowElement element, BpmnElementProcessor<ExecutableFlowElement> processor, BpmnElementContext context) {
        return this.processElementWithListeners(element, context, ExecutableFlowNode::getEndExecutionListeners, processor::finalizeCompletion);
    }

    private Either<Failure, ?> processElementWithListeners(ExecutableFlowElement element, BpmnElementContext context, Function<ExecutableFlowNode, List<ExecutionListener>> listenersGetter, BiFunction<ExecutableFlowElement, BpmnElementContext, Either<Failure, ?>> finalizer) {
        if (!(element instanceof ExecutableFlowNode)) {
            return BpmnElementProcessor.SUCCESS;
        }
        ExecutableFlowNode node = (ExecutableFlowNode)element;
        List<ExecutionListener> listeners = listenersGetter.apply(node);
        if (listeners.isEmpty()) {
            return finalizer.apply(element, context);
        }
        return this.createExecutionListenerJob(element, context, listeners.getFirst());
    }

    private Either<Failure, ?> createExecutionListenerJob(ExecutableFlowElement element, BpmnElementContext context, ExecutionListener listener) {
        return this.jobBehavior.evaluateJobExpressions(listener.getJobWorkerProperties(), context).thenDo(elJobProperties -> this.jobBehavior.createNewExecutionListenerJob(context, element, (BpmnJobBehavior.JobProperties)elJobProperties, listener));
    }

    public Either<Failure, ?> onStartExecutionListenerComplete(ExecutableFlowNode element, BpmnElementProcessor<ExecutableFlowElement> processor, BpmnElementContext context) {
        this.mergeVariablesOfExecutionListener(context, true);
        return this.onExecutionListenerComplete(element, context, ExecutableFlowNode::getStartExecutionListeners, processor::finalizeActivation);
    }

    public Either<Failure, ?> onEndExecutionListenerComplete(ExecutableFlowNode element, BpmnElementProcessor<ExecutableFlowElement> processor, BpmnElementContext context) {
        this.mergeVariablesOfExecutionListener(context, false);
        return this.onExecutionListenerComplete(element, context, ExecutableFlowNode::getEndExecutionListeners, processor::finalizeCompletion);
    }

    private Either<Failure, ?> onExecutionListenerComplete(ExecutableFlowNode element, BpmnElementContext context, Function<ExecutableFlowNode, List<ExecutionListener>> listenersGetter, BiFunction<ExecutableFlowElement, BpmnElementContext, Either<Failure, ?>> finalizer) {
        int currentListenerIndex;
        List<ExecutionListener> listeners = listenersGetter.apply(element);
        Optional<ExecutionListener> nextListener = this.findNextExecutionListener(listeners, currentListenerIndex = this.stateBehavior.getElementInstance(context).getExecutionListenerIndex());
        return nextListener.isPresent() ? this.createExecutionListenerJob(element, context, nextListener.get()) : finalizer.apply(element, context);
    }

    private Optional<ExecutionListener> findNextExecutionListener(List<ExecutionListener> listeners, int nextListenerIndex) {
        return listeners.stream().skip(nextListenerIndex).findFirst();
    }

    private void mergeVariablesOfExecutionListener(BpmnElementContext context, boolean local) {
        Optional.ofNullable(this.eventScopeInstanceState.peekEventTrigger(context.getElementInstanceKey())).ifPresent(eventTrigger -> {
            if (eventTrigger.getVariables().capacity() > 0) {
                long scopeKey = local || context.getFlowScopeKey() <= 0L ? context.getElementInstanceKey() : context.getFlowScopeKey();
                this.variableBehavior.mergeLocalDocument(scopeKey, context.getProcessDefinitionKey(), context.getProcessInstanceKey(), context.getBpmnProcessId(), context.getTenantId(), eventTrigger.getVariables());
            }
            this.eventTriggerBehavior.processEventTriggered(eventTrigger.getEventKey(), context.getProcessDefinitionKey(), eventTrigger.getProcessInstanceKey(), context.getTenantId(), context.getElementInstanceKey(), eventTrigger.getElementId());
        });
    }

    private ExecutableFlowElement getElement(ProcessInstanceRecord recordValue, BpmnElementProcessor<ExecutableFlowElement> processor) {
        return this.processState.getFlowElement(recordValue.getProcessDefinitionKey(), recordValue.getTenantId(), recordValue.getElementIdBuffer(), processor.getType());
    }
}

