/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.metrics;

import io.camunda.zeebe.engine.metrics.EngineMetricsDoc;
import io.camunda.zeebe.util.micrometer.StatefulGauge;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;

public final class IncidentMetrics {
    private final Counter incidentCreated;
    private final Counter incidentResolved;
    private final StatefulGauge pendingIncidents;

    public IncidentMetrics(MeterRegistry meterRegistry) {
        this.pendingIncidents = StatefulGauge.builder((String)EngineMetricsDoc.PENDING_INCIDENTS.getName()).description(EngineMetricsDoc.PENDING_INCIDENTS.getDescription()).register(meterRegistry);
        this.incidentCreated = this.registerCounter(meterRegistry, EngineMetricsDoc.IncidentAction.CREATED);
        this.incidentResolved = this.registerCounter(meterRegistry, EngineMetricsDoc.IncidentAction.RESOLVED);
    }

    public void incidentCreated() {
        this.incidentCreated.increment();
        this.pendingIncidents.increment();
    }

    public void incidentResolved() {
        this.incidentResolved.increment();
        this.pendingIncidents.decrement();
    }

    private Counter registerCounter(MeterRegistry meterRegistry, EngineMetricsDoc.IncidentAction action) {
        return Counter.builder((String)EngineMetricsDoc.INCIDENT_EVENTS.getName()).description(EngineMetricsDoc.INCIDENT_EVENTS.getDescription()).tag(EngineMetricsDoc.EngineKeyNames.INCIDENT_ACTION.asString(), action.toString()).register(meterRegistry);
    }
}

