/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.message;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.engine.state.message.RequestData;
import io.camunda.zeebe.engine.state.mutable.MutableMessageCorrelationState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;

public class DbMessageCorrelationState
implements MutableMessageCorrelationState {
    private final DbLong messageKey = new DbLong();
    private final RequestData requestData = new RequestData();
    private final ColumnFamily<DbLong, RequestData> messageCorrelationColumnFamily;

    public DbMessageCorrelationState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.messageCorrelationColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_CORRELATION, transactionContext, (DbKey)this.messageKey, (DbValue)this.requestData);
    }

    @Override
    public void removeMessageCorrelation(long messageKey) {
        this.messageKey.wrapLong(messageKey);
        this.messageCorrelationColumnFamily.deleteExisting((DbKey)this.messageKey);
    }

    @Override
    public void putMessageCorrelation(long messageKey, long requestId, int requestStreamId) {
        this.messageKey.wrapLong(messageKey);
        this.requestData.setRequestIdProp(requestId).setRequestStreamIdProp(requestStreamId);
        this.messageCorrelationColumnFamily.insert((DbKey)this.messageKey, (DbValue)this.requestData);
    }

    @Override
    public RequestData getRequestData(long messageKey) {
        this.messageKey.wrapLong(messageKey);
        return ((RequestData)this.messageCorrelationColumnFamily.get((DbKey)this.messageKey)).copy();
    }

    @Override
    public boolean existsRequestDataForMessageKey(long messageKey) {
        this.messageKey.wrapLong(messageKey);
        return this.messageCorrelationColumnFamily.exists((DbKey)this.messageKey);
    }
}

