/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.instance;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.engine.state.immutable.UserTaskState;
import io.camunda.zeebe.engine.state.instance.UserTaskLifecycleStateValue;
import io.camunda.zeebe.engine.state.instance.UserTaskRecordValue;
import io.camunda.zeebe.engine.state.mutable.MutableUserTaskState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.usertask.UserTaskRecord;
import java.util.List;
import java.util.Map;

public class DbUserTaskState
implements UserTaskState,
MutableUserTaskState {
    private final UserTaskRecordValue userTaskRecordToRead = new UserTaskRecordValue();
    private final UserTaskRecordValue userTaskRecordToWrite = new UserTaskRecordValue();
    private final DbLong userTaskKey;
    private final ColumnFamily<DbLong, UserTaskRecordValue> userTasksColumnFamily;
    private final DbForeignKey<DbLong> fkUserTask;
    private final UserTaskLifecycleStateValue userTaskState = new UserTaskLifecycleStateValue();
    private final ColumnFamily<DbForeignKey<DbLong>, UserTaskLifecycleStateValue> statesUserTaskColumnFamily;

    public DbUserTaskState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.userTaskKey = new DbLong();
        this.fkUserTask = new DbForeignKey((DbKey)this.userTaskKey, (Enum)ZbColumnFamilies.USER_TASKS);
        this.userTasksColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.USER_TASKS, transactionContext, (DbKey)this.userTaskKey, (DbValue)this.userTaskRecordToRead);
        this.statesUserTaskColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.USER_TASK_STATES, transactionContext, this.fkUserTask, (DbValue)this.userTaskState);
    }

    @Override
    public void create(UserTaskRecord userTask) {
        this.userTaskKey.wrapLong(userTask.getUserTaskKey());
        this.userTaskRecordToWrite.setRecordWithoutVariables(userTask);
        this.userTasksColumnFamily.insert((DbKey)this.userTaskKey, (DbValue)this.userTaskRecordToWrite);
        this.userTaskState.setLifecycleState(UserTaskState.LifecycleState.CREATING);
        this.statesUserTaskColumnFamily.insert(this.fkUserTask, (DbValue)this.userTaskState);
    }

    @Override
    public void update(UserTaskRecord userTask) {
        this.userTaskKey.wrapLong(userTask.getUserTaskKey());
        this.userTaskRecordToWrite.setRecordWithoutVariables(userTask);
        this.userTasksColumnFamily.update((DbKey)this.userTaskKey, (DbValue)this.userTaskRecordToWrite);
    }

    @Override
    public void updateUserTaskLifecycleState(long key, UserTaskState.LifecycleState newLifecycleState) {
        this.userTaskKey.wrapLong(key);
        this.userTaskState.setLifecycleState(newLifecycleState);
        this.statesUserTaskColumnFamily.update(this.fkUserTask, (DbValue)this.userTaskState);
    }

    @Override
    public void delete(long key) {
        this.userTaskKey.wrapLong(key);
        this.userTasksColumnFamily.deleteExisting((DbKey)this.userTaskKey);
        this.statesUserTaskColumnFamily.deleteExisting(this.fkUserTask);
    }

    @Override
    public UserTaskState.LifecycleState getLifecycleState(long key) {
        this.userTaskKey.wrapLong(key);
        UserTaskLifecycleStateValue storedLifecycleState = (UserTaskLifecycleStateValue)this.statesUserTaskColumnFamily.get(this.fkUserTask);
        if (storedLifecycleState == null) {
            return UserTaskState.LifecycleState.NOT_FOUND;
        }
        return storedLifecycleState.getLifecycleState();
    }

    @Override
    public UserTaskRecord getUserTask(long key) {
        this.userTaskKey.wrapLong(key);
        UserTaskRecordValue userTask = (UserTaskRecordValue)this.userTasksColumnFamily.get((DbKey)this.userTaskKey);
        return userTask == null ? null : userTask.getRecord();
    }

    @Override
    public UserTaskRecord getUserTask(long key, Map<String, Object> authorizations) {
        UserTaskRecord userTask = this.getUserTask(key);
        if (userTask != null && this.getAuthorizedTenantIds(authorizations).contains(userTask.getTenantId())) {
            return userTask;
        }
        return null;
    }

    private List<String> getAuthorizedTenantIds(Map<String, Object> authorizations) {
        return (List)authorizations.get("authorized_tenants");
    }
}

