/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.appliers;

import io.camunda.zeebe.engine.state.TypedEventApplier;
import io.camunda.zeebe.engine.state.mutable.MutableJobState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import java.util.Set;

public class JobUpdatedApplier
implements TypedEventApplier<JobIntent, JobRecord> {
    private final MutableJobState jobState;

    JobUpdatedApplier(MutableProcessingState state) {
        this.jobState = state.getJobState();
    }

    @Override
    public void applyState(long key, JobRecord value) {
        Set changeset = value.getChangedAttributes();
        if (changeset.isEmpty()) {
            return;
        }
        if (changeset.contains("retries")) {
            this.jobState.updateJobRetries(key, value.getRetries());
        }
        if (changeset.contains("timeout")) {
            this.jobState.updateJobDeadline(key, value.getDeadline());
        }
    }
}

