/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.variable;

import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class DocumentEntry {
    private final DirectBuffer name = new UnsafeBuffer();
    private final DirectBuffer value = new UnsafeBuffer();

    DocumentEntry() {
    }

    DocumentEntry(DirectBuffer name, DirectBuffer value) {
        this.name.wrap(name);
        this.value.wrap(value);
    }

    void wrap(DirectBuffer buffer, int nameOffset, int nameLength, int valueOffset, int valueLength) {
        this.name.wrap(buffer, nameOffset, nameLength);
        this.value.wrap(buffer, valueOffset, valueLength);
    }

    public DirectBuffer getName() {
        return this.name;
    }

    public DirectBuffer getValue() {
        return this.value;
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        result = 31 * result + this.getValue().hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentEntry that = (DocumentEntry)o;
        if (!this.getName().equals((Object)that.getName())) {
            return false;
        }
        return this.getValue().equals((Object)that.getValue());
    }

    public String toString() {
        return "DocumentEntry{name=" + BufferUtil.bufferAsString((DirectBuffer)this.name) + ", value=" + BufferUtil.bufferAsHexString((DirectBuffer)this.value) + "}";
    }
}

