/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_8_4.corrections;

import io.camunda.zeebe.db.impl.DbBytes;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public final class ColumnFamilyCorrectionException
extends RuntimeException {
    public ColumnFamilyCorrectionException(String reason, DbBytes key, DbBytes value, ZbColumnFamilies columnFamily) {
        super(ColumnFamilyCorrectionException.formatMessage(reason, key, value, columnFamily));
    }

    public ColumnFamilyCorrectionException(String reason, DbBytes key, DbBytes value, ZbColumnFamilies columnFamily, Throwable cause) {
        super(ColumnFamilyCorrectionException.formatMessage(reason, key, value, columnFamily), cause);
    }

    private static String formatMessage(String reason, DbBytes key, DbBytes value, ZbColumnFamilies columnFamily) {
        return String.format("Failed to correct prefix of column family [%d] %s, due to %s - key[%s], value[%s]", columnFamily.ordinal(), columnFamily.name(), reason, BufferUtil.bufferAsHexString((DirectBuffer)key.getDirectBuffer()), BufferUtil.bufferAsHexString((DirectBuffer)value.getDirectBuffer()));
    }
}

