/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.deployment;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbInt;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.db.impl.DbTenantAwareKey;
import io.camunda.zeebe.dmn.DecisionEngine;
import io.camunda.zeebe.dmn.DecisionEngineFactory;
import io.camunda.zeebe.dmn.ParsedDecisionRequirementsGraph;
import io.camunda.zeebe.engine.EngineConfiguration;
import io.camunda.zeebe.engine.state.deployment.DeployedDrg;
import io.camunda.zeebe.engine.state.deployment.PersistedDecision;
import io.camunda.zeebe.engine.state.deployment.PersistedDecisionRequirements;
import io.camunda.zeebe.engine.state.mutable.MutableDecisionState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRequirementsRecord;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.agrona.DirectBuffer;

public final class DbDecisionState
implements MutableDecisionState {
    private final DecisionEngine decisionEngine = DecisionEngineFactory.createDecisionEngine();
    private final DbString tenantIdKey = new DbString();
    private final DbLong dbDecisionKey = new DbLong();
    private final DbTenantAwareKey<DbLong> tenantAwareDecisionKey = new DbTenantAwareKey(this.tenantIdKey, (DbKey)this.dbDecisionKey, DbTenantAwareKey.PlacementType.PREFIX);
    private final DbForeignKey<DbTenantAwareKey<DbLong>> fkDecision = new DbForeignKey(this.tenantAwareDecisionKey, (Enum)ZbColumnFamilies.DMN_DECISIONS);
    private final PersistedDecision dbPersistedDecision = new PersistedDecision();
    private final DbString dbDecisionId;
    private final DbTenantAwareKey<DbString> tenantAwareDecisionId;
    private final DbLong dbDecisionRequirementsKey;
    private final DbTenantAwareKey<DbLong> tenantAwareDecisionRequirementsKey;
    private final DbForeignKey<DbTenantAwareKey<DbLong>> fkDecisionRequirements;
    private final PersistedDecisionRequirements dbPersistedDecisionRequirements;
    private final DbString dbDecisionRequirementsId;
    private final DbTenantAwareKey<DbString> tenantAwareDecisionRequirementsId;
    private final DbCompositeKey<DbForeignKey<DbTenantAwareKey<DbLong>>, DbForeignKey<DbTenantAwareKey<DbLong>>> dbDecisionRequirementsKeyAndDecisionKey;
    private final ColumnFamily<DbCompositeKey<DbForeignKey<DbTenantAwareKey<DbLong>>, DbForeignKey<DbTenantAwareKey<DbLong>>>, DbNil> decisionKeyByDecisionRequirementsKey;
    private final ColumnFamily<DbTenantAwareKey<DbLong>, PersistedDecision> decisionsByKey;
    private final ColumnFamily<DbTenantAwareKey<DbString>, DbForeignKey<DbTenantAwareKey<DbLong>>> latestDecisionKeysByDecisionId;
    private final DbInt dbDecisionVersion;
    private final DbCompositeKey<DbString, DbInt> decisionIdAndVersion;
    private final DbTenantAwareKey<DbCompositeKey<DbString, DbInt>> tenantAwareDecisionIdAndVersion;
    private final ColumnFamily<DbTenantAwareKey<DbCompositeKey<DbString, DbInt>>, DbForeignKey<DbTenantAwareKey<DbLong>>> decisionKeyByDecisionIdAndVersion;
    private final ColumnFamily<DbTenantAwareKey<DbLong>, PersistedDecisionRequirements> decisionRequirementsByKey;
    private final ColumnFamily<DbTenantAwareKey<DbString>, DbForeignKey<DbTenantAwareKey<DbLong>>> latestDecisionRequirementsKeysById;
    private final DbInt dbDecisionRequirementsVersion;
    private final DbCompositeKey<DbString, DbInt> decisionRequirementsIdAndVersion;
    private final DbTenantAwareKey<DbCompositeKey<DbString, DbInt>> tenantAwareDecisionRequirementsIdAndVersion;
    private final ColumnFamily<DbTenantAwareKey<DbCompositeKey<DbString, DbInt>>, DbForeignKey<DbTenantAwareKey<DbLong>>> decisionRequirementsKeyByIdAndVersion;
    private final LoadingCache<TenantIdAndDrgKey, DeployedDrg> drgCache;

    public DbDecisionState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext, EngineConfiguration config) {
        this.decisionsByKey = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DMN_DECISIONS, transactionContext, this.tenantAwareDecisionKey, (DbValue)this.dbPersistedDecision);
        this.dbDecisionId = new DbString();
        this.tenantAwareDecisionId = new DbTenantAwareKey(this.tenantIdKey, (DbKey)this.dbDecisionId, DbTenantAwareKey.PlacementType.PREFIX);
        this.latestDecisionKeysByDecisionId = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DMN_LATEST_DECISION_BY_ID, transactionContext, this.tenantAwareDecisionId, this.fkDecision);
        this.dbDecisionRequirementsKey = new DbLong();
        this.tenantAwareDecisionRequirementsKey = new DbTenantAwareKey(this.tenantIdKey, (DbKey)this.dbDecisionRequirementsKey, DbTenantAwareKey.PlacementType.PREFIX);
        this.fkDecisionRequirements = new DbForeignKey(this.tenantAwareDecisionRequirementsKey, (Enum)ZbColumnFamilies.DMN_DECISION_REQUIREMENTS);
        this.dbPersistedDecisionRequirements = new PersistedDecisionRequirements();
        this.decisionRequirementsByKey = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DMN_DECISION_REQUIREMENTS, transactionContext, this.tenantAwareDecisionRequirementsKey, (DbValue)this.dbPersistedDecisionRequirements);
        this.dbDecisionRequirementsId = new DbString();
        this.tenantAwareDecisionRequirementsId = new DbTenantAwareKey(this.tenantIdKey, (DbKey)this.dbDecisionRequirementsId, DbTenantAwareKey.PlacementType.PREFIX);
        this.latestDecisionRequirementsKeysById = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DMN_LATEST_DECISION_REQUIREMENTS_BY_ID, transactionContext, this.tenantAwareDecisionRequirementsId, this.fkDecisionRequirements);
        this.dbDecisionRequirementsKeyAndDecisionKey = new DbCompositeKey(this.fkDecisionRequirements, this.fkDecision);
        this.decisionKeyByDecisionRequirementsKey = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DMN_DECISION_KEY_BY_DECISION_REQUIREMENTS_KEY, transactionContext, this.dbDecisionRequirementsKeyAndDecisionKey, (DbValue)DbNil.INSTANCE);
        this.dbDecisionVersion = new DbInt();
        this.decisionIdAndVersion = new DbCompositeKey((DbKey)this.dbDecisionId, (DbKey)this.dbDecisionVersion);
        this.tenantAwareDecisionIdAndVersion = new DbTenantAwareKey(this.tenantIdKey, this.decisionIdAndVersion, DbTenantAwareKey.PlacementType.PREFIX);
        this.decisionKeyByDecisionIdAndVersion = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DMN_DECISION_KEY_BY_DECISION_ID_AND_VERSION, transactionContext, this.tenantAwareDecisionIdAndVersion, this.fkDecision);
        this.dbDecisionRequirementsVersion = new DbInt();
        this.decisionRequirementsIdAndVersion = new DbCompositeKey((DbKey)this.dbDecisionRequirementsId, (DbKey)this.dbDecisionRequirementsVersion);
        this.tenantAwareDecisionRequirementsIdAndVersion = new DbTenantAwareKey(this.tenantIdKey, this.decisionRequirementsIdAndVersion, DbTenantAwareKey.PlacementType.PREFIX);
        this.decisionRequirementsKeyByIdAndVersion = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DMN_DECISION_REQUIREMENTS_KEY_BY_DECISION_REQUIREMENT_ID_AND_VERSION, transactionContext, this.tenantAwareDecisionRequirementsIdAndVersion, this.fkDecisionRequirements);
        this.drgCache = CacheBuilder.newBuilder().maximumSize((long)config.getDrgCacheCapacity()).build((CacheLoader)new CacheLoader<TenantIdAndDrgKey, DeployedDrg>(){

            public DeployedDrg load(TenantIdAndDrgKey tenantIdAndDrgKey) throws DrgNotFoundException {
                return DbDecisionState.this.findAndParseDecisionRequirementsByKeyFromDb(tenantIdAndDrgKey.drgKey, tenantIdAndDrgKey.tenantId);
            }
        });
    }

    @Override
    public Optional<PersistedDecision> findLatestDecisionByIdAndTenant(DirectBuffer decisionId, String tenantId) {
        this.dbDecisionId.wrapBuffer(decisionId);
        this.tenantIdKey.wrapString(tenantId);
        return Optional.ofNullable((DbForeignKey)this.latestDecisionKeysByDecisionId.get(this.tenantAwareDecisionId)).flatMap(decisionKey -> this.findDecisionByTenantAndKey(tenantId, ((DbLong)((DbTenantAwareKey)decisionKey.inner()).wrappedKey()).getValue()));
    }

    @Override
    public Optional<PersistedDecision> findDecisionByTenantAndKey(String tenantId, long decisionKey) {
        this.dbDecisionKey.wrapLong(decisionKey);
        this.tenantIdKey.wrapString(tenantId);
        return Optional.ofNullable((PersistedDecision)this.decisionsByKey.get(this.tenantAwareDecisionKey)).map(PersistedDecision::copy);
    }

    @Override
    public Optional<DeployedDrg> findLatestDecisionRequirementsByTenantAndId(String tenantId, DirectBuffer decisionRequirementsId) {
        this.tenantIdKey.wrapString(tenantId);
        this.dbDecisionRequirementsId.wrapBuffer(decisionRequirementsId);
        return Optional.ofNullable((DbForeignKey)this.latestDecisionRequirementsKeysById.get(this.tenantAwareDecisionRequirementsId)).map(requirementsKey -> ((DbLong)((DbTenantAwareKey)requirementsKey.inner()).wrappedKey()).getValue()).flatMap(decisionRequirementsKey -> this.findDecisionRequirementsByTenantAndKey(tenantId, (long)decisionRequirementsKey));
    }

    @Override
    public Optional<DeployedDrg> findDecisionRequirementsByTenantAndKey(String tenantId, long decisionRequirementsKey) {
        return this.findDeployedDrg(decisionRequirementsKey, tenantId);
    }

    @Override
    public List<PersistedDecision> findDecisionsByTenantAndDecisionRequirementsKey(String tenantId, long decisionRequirementsKey) {
        ArrayList<PersistedDecision> decisions = new ArrayList<PersistedDecision>();
        this.tenantIdKey.wrapString(tenantId);
        this.dbDecisionRequirementsKey.wrapLong(decisionRequirementsKey);
        this.decisionKeyByDecisionRequirementsKey.whileEqualPrefix((DbKey)new DbCompositeKey((DbKey)this.tenantIdKey, (DbKey)this.dbDecisionRequirementsKey), (key, nil) -> {
            long decisionKey = ((DbLong)((DbTenantAwareKey)((DbForeignKey)key.second()).inner()).wrappedKey()).getValue();
            this.findDecisionByTenantAndKey(tenantId, decisionKey).ifPresent(decisions::add);
        });
        return decisions;
    }

    @Override
    public void clearCache() {
        this.drgCache.invalidateAll();
    }

    private DeployedDrg findAndParseDecisionRequirementsByKeyFromDb(long decisionRequirementsKey, String tenantId) throws DrgNotFoundException {
        this.tenantIdKey.wrapString(tenantId);
        this.dbDecisionRequirementsKey.wrapLong(decisionRequirementsKey);
        PersistedDecisionRequirements persistedDrg = (PersistedDecisionRequirements)this.decisionRequirementsByKey.get(this.tenantAwareDecisionRequirementsKey);
        if (persistedDrg == null) {
            throw new DrgNotFoundException();
        }
        PersistedDecisionRequirements copiedDrg = persistedDrg.copy();
        byte[] resourceBytes = BufferUtil.bufferAsArray((DirectBuffer)copiedDrg.getResource());
        ParsedDecisionRequirementsGraph parsedDrg = this.decisionEngine.parse((InputStream)new ByteArrayInputStream(resourceBytes));
        return new DeployedDrg(parsedDrg, copiedDrg);
    }

    private Optional<DeployedDrg> findDeployedDrg(long decisionRequirementsKey, String tenantId) {
        try {
            return Optional.of((DeployedDrg)this.drgCache.get((Object)new TenantIdAndDrgKey(tenantId, decisionRequirementsKey)));
        }
        catch (ExecutionException e) {
            return Optional.empty();
        }
    }

    private Optional<Long> findPreviousVersionDecisionKey(DirectBuffer decisionId, int currentVersion, String tenantId) {
        HashMap decisionKeysByVersion = new HashMap();
        this.tenantIdKey.wrapString(tenantId);
        this.dbDecisionId.wrapBuffer(decisionId);
        this.decisionKeyByDecisionIdAndVersion.whileEqualPrefix((DbKey)new DbCompositeKey((DbKey)this.tenantIdKey, (DbKey)this.dbDecisionId), (key, decisionKey) -> {
            if (((DbInt)((DbCompositeKey)key.wrappedKey()).second()).getValue() < currentVersion) {
                decisionKeysByVersion.put(((DbInt)((DbCompositeKey)key.wrappedKey()).second()).getValue(), ((DbLong)((DbTenantAwareKey)decisionKey.inner()).wrappedKey()).getValue());
            }
        });
        if (decisionKeysByVersion.isEmpty()) {
            return Optional.empty();
        }
        Integer previousVersion = (Integer)Collections.max(decisionKeysByVersion.keySet());
        return Optional.of((Long)decisionKeysByVersion.get(previousVersion));
    }

    private Optional<Long> findPreviousVersionDecisionRequirementsKey(DirectBuffer decisionRequirementsId, int currentVersion, String tenantId) {
        HashMap decisionRequirementsKeysByVersion = new HashMap();
        this.tenantIdKey.wrapString(tenantId);
        this.dbDecisionRequirementsId.wrapBuffer(decisionRequirementsId);
        this.decisionRequirementsKeyByIdAndVersion.whileEqualPrefix((DbKey)new DbCompositeKey((DbKey)this.tenantIdKey, (DbKey)this.dbDecisionRequirementsId), (key, drgKey) -> {
            if (((DbInt)((DbCompositeKey)key.wrappedKey()).second()).getValue() < currentVersion) {
                decisionRequirementsKeysByVersion.put(((DbInt)((DbCompositeKey)key.wrappedKey()).second()).getValue(), ((DbLong)((DbTenantAwareKey)drgKey.inner()).wrappedKey()).getValue());
            }
        });
        if (decisionRequirementsKeysByVersion.isEmpty()) {
            return Optional.empty();
        }
        Integer previousVersion = (Integer)Collections.max(decisionRequirementsKeysByVersion.keySet());
        return Optional.of((Long)decisionRequirementsKeysByVersion.get(previousVersion));
    }

    @Override
    public void storeDecisionRecord(DecisionRecord record) {
        this.tenantIdKey.wrapString(record.getTenantId());
        this.dbDecisionKey.wrapLong(record.getDecisionKey());
        this.dbPersistedDecision.wrap(record);
        this.decisionsByKey.upsert(this.tenantAwareDecisionKey, (DbValue)this.dbPersistedDecision);
        this.dbDecisionKey.wrapLong(record.getDecisionKey());
        this.dbDecisionRequirementsKey.wrapLong(record.getDecisionRequirementsKey());
        this.decisionKeyByDecisionRequirementsKey.upsert(this.dbDecisionRequirementsKeyAndDecisionKey, (DbValue)DbNil.INSTANCE);
        this.dbDecisionId.wrapString(record.getDecisionId());
        this.dbDecisionVersion.wrapInt(record.getVersion());
        this.decisionKeyByDecisionIdAndVersion.upsert(this.tenantAwareDecisionIdAndVersion, this.fkDecision);
        this.updateLatestDecisionVersion(record);
    }

    @Override
    public void storeDecisionRequirements(DecisionRequirementsRecord record) {
        this.tenantIdKey.wrapString(record.getTenantId());
        this.dbDecisionRequirementsKey.wrapLong(record.getDecisionRequirementsKey());
        this.dbPersistedDecisionRequirements.wrap(record);
        this.decisionRequirementsByKey.upsert(this.tenantAwareDecisionRequirementsKey, (DbValue)this.dbPersistedDecisionRequirements);
        this.dbDecisionRequirementsId.wrapString(record.getDecisionRequirementsId());
        this.dbDecisionRequirementsVersion.wrapInt(record.getDecisionRequirementsVersion());
        this.decisionRequirementsKeyByIdAndVersion.upsert(this.tenantAwareDecisionRequirementsIdAndVersion, this.fkDecisionRequirements);
        this.updateLatestDecisionRequirementsVersion(record);
    }

    @Override
    public void deleteDecision(DecisionRecord record) {
        this.tenantIdKey.wrapString(record.getTenantId());
        this.findLatestDecisionByIdAndTenant(record.getDecisionIdBuffer(), record.getTenantId()).map(PersistedDecision::getVersion).ifPresent(latestVersion -> {
            if (latestVersion.intValue() == record.getVersion()) {
                this.dbDecisionId.wrapBuffer(record.getDecisionIdBuffer());
                this.findPreviousVersionDecisionKey(record.getDecisionIdBuffer(), record.getVersion(), record.getTenantId()).ifPresentOrElse(previousDecisionKey -> {
                    this.dbDecisionKey.wrapLong(previousDecisionKey.longValue());
                    this.latestDecisionKeysByDecisionId.update(this.tenantAwareDecisionId, this.fkDecision);
                }, () -> this.latestDecisionKeysByDecisionId.deleteExisting(this.tenantAwareDecisionId));
            }
        });
        this.dbDecisionRequirementsKey.wrapLong(record.getDecisionRequirementsKey());
        this.dbDecisionKey.wrapLong(record.getDecisionKey());
        this.dbDecisionId.wrapBuffer(record.getDecisionIdBuffer());
        this.dbDecisionVersion.wrapInt(record.getVersion());
        this.decisionKeyByDecisionRequirementsKey.deleteExisting(this.dbDecisionRequirementsKeyAndDecisionKey);
        this.decisionsByKey.deleteExisting(this.tenantAwareDecisionKey);
        this.decisionKeyByDecisionIdAndVersion.deleteExisting(this.tenantAwareDecisionIdAndVersion);
    }

    @Override
    public void deleteDecisionRequirements(DecisionRequirementsRecord record) {
        this.tenantIdKey.wrapString(record.getTenantId());
        this.findLatestDecisionRequirementsByTenantAndId(record.getTenantId(), record.getDecisionRequirementsIdBuffer()).map(DeployedDrg::getDecisionRequirementsVersion).ifPresent(latestVersion -> {
            if (latestVersion.intValue() == record.getDecisionRequirementsVersion()) {
                this.dbDecisionRequirementsId.wrapBuffer(record.getDecisionRequirementsIdBuffer());
                this.findPreviousVersionDecisionRequirementsKey(record.getDecisionRequirementsIdBuffer(), record.getDecisionRequirementsVersion(), record.getTenantId()).ifPresentOrElse(previousDrgKey -> {
                    this.dbDecisionRequirementsKey.wrapLong(previousDrgKey.longValue());
                    this.latestDecisionRequirementsKeysById.update(this.tenantAwareDecisionRequirementsId, this.fkDecisionRequirements);
                }, () -> this.latestDecisionRequirementsKeysById.deleteExisting(this.tenantAwareDecisionRequirementsId));
            }
        });
        this.dbDecisionRequirementsKey.wrapLong(record.getDecisionRequirementsKey());
        this.dbDecisionRequirementsId.wrapBuffer(record.getDecisionRequirementsIdBuffer());
        this.dbDecisionRequirementsVersion.wrapInt(record.getDecisionRequirementsVersion());
        this.decisionRequirementsByKey.deleteExisting(this.tenantAwareDecisionRequirementsKey);
        this.decisionRequirementsKeyByIdAndVersion.deleteExisting(this.tenantAwareDecisionRequirementsIdAndVersion);
        this.drgCache.invalidate((Object)new TenantIdAndDrgKey(record.getTenantId(), record.getDecisionRequirementsKey()));
    }

    private void updateLatestDecisionVersion(DecisionRecord record) {
        this.findLatestDecisionByIdAndTenant(record.getDecisionIdBuffer(), record.getTenantId()).ifPresentOrElse(previousVersion -> {
            if (record.getVersion() > previousVersion.getVersion()) {
                this.updateDecisionAsLatestVersion(record);
            }
        }, () -> this.insertDecisionAsLatestVersion(record));
    }

    private void updateDecisionAsLatestVersion(DecisionRecord record) {
        this.tenantIdKey.wrapString(record.getTenantId());
        this.dbDecisionId.wrapBuffer(record.getDecisionIdBuffer());
        this.dbDecisionKey.wrapLong(record.getDecisionKey());
        this.latestDecisionKeysByDecisionId.update(this.tenantAwareDecisionId, this.fkDecision);
    }

    private void insertDecisionAsLatestVersion(DecisionRecord record) {
        this.tenantIdKey.wrapString(record.getTenantId());
        this.dbDecisionId.wrapBuffer(record.getDecisionIdBuffer());
        this.dbDecisionKey.wrapLong(record.getDecisionKey());
        this.latestDecisionKeysByDecisionId.upsert(this.tenantAwareDecisionId, this.fkDecision);
    }

    private void updateLatestDecisionRequirementsVersion(DecisionRequirementsRecord record) {
        this.findLatestDecisionRequirementsByTenantAndId(record.getTenantId(), record.getDecisionRequirementsIdBuffer()).ifPresentOrElse(previousVersion -> {
            if (record.getDecisionRequirementsVersion() > previousVersion.getDecisionRequirementsVersion()) {
                this.updateDecisionRequirementsAsLatestVersion(record);
            }
        }, () -> this.insertDecisionRequirementsAsLatestVersion(record));
    }

    private void updateDecisionRequirementsAsLatestVersion(DecisionRequirementsRecord record) {
        this.tenantIdKey.wrapString(record.getTenantId());
        this.dbDecisionRequirementsId.wrapBuffer(record.getDecisionRequirementsIdBuffer());
        this.dbDecisionRequirementsKey.wrapLong(record.getDecisionRequirementsKey());
        this.latestDecisionRequirementsKeysById.update(this.tenantAwareDecisionRequirementsId, this.fkDecisionRequirements);
    }

    private void insertDecisionRequirementsAsLatestVersion(DecisionRequirementsRecord record) {
        this.tenantIdKey.wrapString(record.getTenantId());
        this.dbDecisionRequirementsId.wrapBuffer(record.getDecisionRequirementsIdBuffer());
        this.dbDecisionRequirementsKey.wrapLong(record.getDecisionRequirementsKey());
        this.latestDecisionRequirementsKeysById.upsert(this.tenantAwareDecisionRequirementsId, this.fkDecisionRequirements);
    }

    private static final class DrgNotFoundException
    extends Exception {
        private DrgNotFoundException() {
        }
    }

    private record TenantIdAndDrgKey(String tenantId, Long drgKey) {
    }
}

