/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.transport.stream.impl.RemoteStreamRegistry;
import io.camunda.zeebe.transport.stream.impl.messages.AddStreamRequest;
import io.camunda.zeebe.transport.stream.impl.messages.AddStreamResponse;
import io.camunda.zeebe.transport.stream.impl.messages.ErrorCode;
import io.camunda.zeebe.transport.stream.impl.messages.ErrorResponse;
import io.camunda.zeebe.transport.stream.impl.messages.RemoveStreamRequest;
import io.camunda.zeebe.transport.stream.impl.messages.RemoveStreamResponse;
import io.camunda.zeebe.transport.stream.impl.messages.StreamResponse;
import io.camunda.zeebe.transport.stream.impl.messages.UUIDEncoder;
import io.camunda.zeebe.util.CloseableSilently;
import java.util.UUID;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteStreamApiHandler<M>
implements CloseableSilently {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteStreamApiHandler.class);
    private static final UUID NULL_ID = new UUID(UUIDEncoder.highNullValue(), UUIDEncoder.lowNullValue());
    private final AddStreamResponse addResponseOK = new AddStreamResponse();
    private final ErrorResponse errorResponse = new ErrorResponse();
    private final RemoveStreamResponse removeResponseOK = new RemoveStreamResponse();
    private final RemoteStreamRegistry<M> registry;
    private final Function<DirectBuffer, M> metadataFactory;

    public RemoteStreamApiHandler(RemoteStreamRegistry<M> registry, Function<DirectBuffer, M> metadataFactory) {
        this.registry = registry;
        this.metadataFactory = metadataFactory;
    }

    public void close() {
        this.registry.clear();
    }

    public StreamResponse add(MemberId sender, AddStreamRequest request) {
        M properties;
        try {
            properties = this.metadataFactory.apply(request.metadata());
        }
        catch (Exception e) {
            String errorMessage = "Failed to parse stream metadata (size = '%d') from AddStreamRequest".formatted(request.metadata().capacity());
            return this.failedResponse(sender, errorMessage, e);
        }
        if (request.streamType().capacity() <= 0) {
            String errorMessage = "Expected a stream type of length > 0, but it has %d".formatted(request.streamType().capacity());
            return this.failedResponse(sender, errorMessage);
        }
        if (request.streamId() == null || request.streamId().equals(NULL_ID)) {
            String errorMessage = "Expected a stream ID, but received a nil UUID ([%s])".formatted(request.streamId());
            return this.failedResponse(sender, errorMessage);
        }
        this.registry.add(new UnsafeBuffer(request.streamType()), request.streamId(), sender, properties);
        LOG.debug("Opened stream {} from {}", (Object)request.streamId(), (Object)sender);
        return this.addResponseOK;
    }

    public StreamResponse remove(MemberId sender, RemoveStreamRequest request) {
        if (request.streamId() == null || request.streamId().equals(NULL_ID)) {
            String errorMessage = "Expected a stream ID, but received a nil UUID ([%s])".formatted(request.streamId());
            return this.failedResponse(sender, errorMessage);
        }
        this.registry.remove(request.streamId(), sender);
        LOG.debug("Removed stream {} from {}", (Object)request.streamId(), (Object)sender);
        return this.removeResponseOK;
    }

    public void removeAll(MemberId sender) {
        this.registry.removeAll(sender);
        LOG.debug("Removed all streams from {}", (Object)sender);
    }

    private ErrorResponse failedResponse(MemberId sender, String errorMessage, Exception cause) {
        LOG.warn("Failed to open stream for '{}': [{}]", new Object[]{sender, errorMessage, cause});
        return this.errorResponse.code(ErrorCode.MALFORMED).message(errorMessage);
    }

    private ErrorResponse failedResponse(MemberId sender, String errorMessage) {
        LOG.warn("Failed to open stream for '{}': [{}]", (Object)sender, (Object)errorMessage);
        return this.errorResponse.code(ErrorCode.INVALID).message(errorMessage);
    }
}

