/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.transport.stream.impl.ClientStreamManager;
import io.camunda.zeebe.transport.stream.impl.messages.ErrorResponse;
import io.camunda.zeebe.transport.stream.impl.messages.PushStreamRequest;
import io.camunda.zeebe.transport.stream.impl.messages.PushStreamResponse;
import io.camunda.zeebe.transport.stream.impl.messages.StreamResponse;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.agrona.collections.ArrayUtil;

final class ClientStreamApiHandler {
    private final ClientStreamManager<?> clientStreamManager;
    private final Executor executor;

    ClientStreamApiHandler(ClientStreamManager<?> clientStreamManager, Executor executor) {
        this.clientStreamManager = clientStreamManager;
        this.executor = executor;
    }

    CompletableFuture<StreamResponse> handlePushRequest(PushStreamRequest request) {
        CompletableFuture<StreamResponse> responseFuture = new CompletableFuture<StreamResponse>();
        CompletableActorFuture payloadPushed = new CompletableActorFuture();
        this.clientStreamManager.onPayloadReceived(request, (ActorFuture<Void>)payloadPushed);
        payloadPushed.onComplete((ok, error) -> this.handlePayloadPushed(responseFuture, (Throwable)error), this.executor);
        return responseFuture;
    }

    byte[] handleRestartRequest(MemberId sender, byte[] ignored) {
        this.clientStreamManager.onServerRemoved(MemberId.from((String)((String)((Object)sender.id()))));
        this.clientStreamManager.onServerJoined(MemberId.from((String)((String)((Object)sender.id()))));
        return ArrayUtil.EMPTY_BYTE_ARRAY;
    }

    private void handlePayloadPushed(CompletableFuture<StreamResponse> response, Throwable error) {
        if (error == null) {
            response.complete(new PushStreamResponse());
            return;
        }
        ErrorResponse errorResponse = new ErrorResponse().code(ErrorResponse.mapErrorToCode(error)).message(error.getMessage());
        for (Throwable detail : error.getSuppressed()) {
            errorResponse.addDetail(ErrorResponse.mapErrorToCode(detail), detail.getMessage());
        }
        response.complete(errorResponse);
    }
}

