/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.api;

import io.camunda.zeebe.transport.stream.impl.messages.ErrorCode;
import io.camunda.zeebe.transport.stream.impl.messages.ErrorResponse;
import io.camunda.zeebe.util.exception.UnrecoverableException;
import java.util.ArrayList;
import java.util.List;

public class StreamResponseException
extends UnrecoverableException {
    private final ErrorCode code;
    private final String message;
    private final List<ErrorDetail> details;

    public StreamResponseException(ErrorResponse response) {
        super("Remote stream server error: [code=%s, message='%s', details=%s]".formatted(new Object[]{response.code(), response.message(), response.details()}));
        this.code = response.code();
        this.message = response.message();
        this.details = new ArrayList<ErrorDetail>(response.details());
    }

    public ErrorCode code() {
        return this.code;
    }

    public String message() {
        return this.message;
    }

    public List<ErrorDetail> details() {
        return this.details;
    }

    public static interface ErrorDetail {
        public ErrorCode code();

        public String message();
    }
}

