/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.impl;

import io.camunda.zeebe.transport.ServerResponse;
import io.camunda.zeebe.util.buffer.BufferWriter;
import io.camunda.zeebe.util.buffer.DirectBufferWriter;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class ServerResponseImpl
implements ServerResponse {
    private final DirectBufferWriter writerAdapter = new DirectBufferWriter();
    private BufferWriter writer;
    private int partitionId;
    private long requestId;

    public ServerResponseImpl writer(BufferWriter writer) {
        this.writer = writer;
        return this;
    }

    public ServerResponseImpl buffer(DirectBuffer buffer) {
        return this.buffer(buffer, 0, buffer.capacity());
    }

    public ServerResponseImpl buffer(DirectBuffer buffer, int offset, int length) {
        return this.writer((BufferWriter)this.writerAdapter.wrap(buffer, offset, length));
    }

    public ServerResponseImpl reset() {
        this.partitionId = -1;
        this.writer = null;
        this.requestId = -1L;
        return this;
    }

    public int getLength() {
        return this.writer.getLength();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.writer.write(buffer, offset);
    }

    public BufferWriter getWriter() {
        return this.writer;
    }

    @Override
    public long getRequestId() {
        return this.requestId;
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    public ServerResponseImpl setPartitionId(int partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    public ServerResponseImpl setRequestId(long requestId) {
        this.requestId = requestId;
        return this;
    }
}

