/* Generated SBE (Simple Binary Encoding) message codec. */
package io.camunda.zeebe.protocol.record;

import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.*;


/**
 * Version information
 */
@SuppressWarnings("all")
public final class VersionEncoder implements CompositeEncoderFlyweight
{
    public static final int SCHEMA_ID = 0;
    public static final int SCHEMA_VERSION = 5;
    public static final String SEMANTIC_VERSION = "8.6.0";
    public static final int ENCODED_LENGTH = 12;
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private int offset;
    private MutableDirectBuffer buffer;

    public VersionEncoder wrap(final MutableDirectBuffer buffer, final int offset)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.offset = offset;

        return this;
    }

    public MutableDirectBuffer buffer()
    {
        return buffer;
    }

    public int offset()
    {
        return offset;
    }

    public int encodedLength()
    {
        return ENCODED_LENGTH;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public static int majorVersionEncodingOffset()
    {
        return 0;
    }

    public static int majorVersionEncodingLength()
    {
        return 4;
    }

    public static int majorVersionNullValue()
    {
        return -2147483648;
    }

    public static int majorVersionMinValue()
    {
        return -2147483647;
    }

    public static int majorVersionMaxValue()
    {
        return 2147483647;
    }

    public VersionEncoder majorVersion(final int value)
    {
        buffer.putInt(offset + 0, value, BYTE_ORDER);
        return this;
    }


    public static int minorVersionEncodingOffset()
    {
        return 4;
    }

    public static int minorVersionEncodingLength()
    {
        return 4;
    }

    public static int minorVersionNullValue()
    {
        return -2147483648;
    }

    public static int minorVersionMinValue()
    {
        return -2147483647;
    }

    public static int minorVersionMaxValue()
    {
        return 2147483647;
    }

    public VersionEncoder minorVersion(final int value)
    {
        buffer.putInt(offset + 4, value, BYTE_ORDER);
        return this;
    }


    public static int patchVersionEncodingOffset()
    {
        return 8;
    }

    public static int patchVersionEncodingLength()
    {
        return 4;
    }

    public static int patchVersionNullValue()
    {
        return -2147483648;
    }

    public static int patchVersionMinValue()
    {
        return -2147483647;
    }

    public static int patchVersionMaxValue()
    {
        return 2147483647;
    }

    public VersionEncoder patchVersion(final int value)
    {
        buffer.putInt(offset + 8, value, BYTE_ORDER);
        return this;
    }


    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        return appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final VersionDecoder decoder = new VersionDecoder();
        decoder.wrap(buffer, offset);

        return decoder.appendTo(builder);
    }
}
