/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.deployment;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.BinaryProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ResourceMetadataRecord;
import io.camunda.zeebe.protocol.record.value.deployment.Resource;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class ResourceRecord
extends UnifiedRecordValue
implements Resource {
    private final StringProperty resourceIdProp = new StringProperty("resourceId", "");
    private final IntegerProperty versionProp = new IntegerProperty("version", -1);
    private final LongProperty resourceKeyProp = new LongProperty("resourceKey", -1L);
    private final BinaryProperty checksumProp = new BinaryProperty("checksum", (DirectBuffer)new UnsafeBuffer());
    private final StringProperty resourceNameProp = new StringProperty("resourceName", "");
    private final StringProperty tenantIdProp = new StringProperty("tenantId", "<default>");
    private final LongProperty deploymentKeyProp = new LongProperty("deploymentKey", -1L);
    private final StringProperty versionTagProp = new StringProperty("versionTag", "");
    private final BinaryProperty resourceProp = new BinaryProperty("resource", (DirectBuffer)new UnsafeBuffer());

    public ResourceRecord() {
        super(9);
        this.declareProperty((BaseProperty)this.resourceIdProp).declareProperty((BaseProperty)this.versionProp).declareProperty((BaseProperty)this.resourceKeyProp).declareProperty((BaseProperty)this.checksumProp).declareProperty((BaseProperty)this.resourceNameProp).declareProperty((BaseProperty)this.tenantIdProp).declareProperty((BaseProperty)this.deploymentKeyProp).declareProperty((BaseProperty)this.versionTagProp).declareProperty((BaseProperty)this.resourceProp);
    }

    public ResourceRecord wrap(ResourceMetadataRecord metadata, byte[] resource) {
        this.resourceIdProp.setValue(metadata.getResourceId());
        this.versionProp.setValue(metadata.getVersion());
        this.checksumProp.setValue(metadata.getChecksumBuffer());
        this.resourceKeyProp.setValue(metadata.getResourceKey());
        this.resourceNameProp.setValue(metadata.getResourceNameBuffer());
        this.tenantIdProp.setValue(metadata.getTenantId());
        this.deploymentKeyProp.setValue(metadata.getDeploymentKey());
        this.versionTagProp.setValue(metadata.getVersionTag());
        this.resourceProp.setValue((DirectBuffer)BufferUtil.wrapArray((byte[])resource));
        return this;
    }

    public String getResourceId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.resourceIdProp.getValue());
    }

    public int getVersion() {
        return this.versionProp.getValue();
    }

    public ResourceRecord setVersion(int version) {
        this.versionProp.setValue(version);
        return this;
    }

    public String getVersionTag() {
        return BufferUtil.bufferAsString((DirectBuffer)this.versionTagProp.getValue());
    }

    public ResourceRecord setVersionTag(String versionTag) {
        this.versionTagProp.setValue(versionTag);
        return this;
    }

    public long getResourceKey() {
        return this.resourceKeyProp.getValue();
    }

    public byte[] getChecksum() {
        return BufferUtil.bufferAsArray((DirectBuffer)this.checksumProp.getValue());
    }

    public ResourceRecord setChecksum(DirectBuffer checksumBuffer) {
        this.checksumProp.setValue(checksumBuffer);
        return this;
    }

    public String getResourceName() {
        return BufferUtil.bufferAsString((DirectBuffer)this.resourceNameProp.getValue());
    }

    public boolean isDuplicate() {
        return false;
    }

    public long getDeploymentKey() {
        return this.deploymentKeyProp.getValue();
    }

    public ResourceRecord setDeploymentKey(long deploymentKey) {
        this.deploymentKeyProp.setValue(deploymentKey);
        return this;
    }

    public ResourceRecord setResourceName(String resourceName) {
        this.resourceNameProp.setValue(resourceName);
        return this;
    }

    public ResourceRecord setResourceName(DirectBuffer resourceName) {
        this.resourceNameProp.setValue(resourceName);
        return this;
    }

    public ResourceRecord setResourceKey(long resourceKey) {
        this.resourceKeyProp.setValue(resourceKey);
        return this;
    }

    public ResourceRecord setResourceId(DirectBuffer resourceId) {
        this.resourceIdProp.setValue(resourceId);
        return this;
    }

    public ResourceRecord setResourceId(String resourceId) {
        this.resourceIdProp.setValue(resourceId);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getChecksumBuffer() {
        return this.checksumProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getResourceNameBuffer() {
        return this.resourceNameProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getResourceIdBuffer() {
        return this.resourceIdProp.getValue();
    }

    @Override
    @JsonIgnore
    public int getLength() {
        return super.getLength();
    }

    @Override
    @JsonIgnore
    public int getEncodedLength() {
        return super.getEncodedLength();
    }

    public String getTenantId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.tenantIdProp.getValue());
    }

    public ResourceRecord setTenantId(String tenantId) {
        this.tenantIdProp.setValue(tenantId);
        return this;
    }

    public String getResourceProp() {
        return BufferUtil.bufferAsString((DirectBuffer)this.resourceProp.getValue());
    }

    public ResourceRecord setResource(DirectBuffer resource) {
        return this.setResource(resource, 0, resource.capacity());
    }

    public ResourceRecord setResource(DirectBuffer resource, int offset, int length) {
        this.resourceProp.setValue(resource, offset, length);
        return this;
    }
}

