/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.authorization;

import io.camunda.zeebe.msgpack.property.ArrayProperty;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.EnumProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.authorization.Permission;
import io.camunda.zeebe.protocol.record.value.AuthorizationOwnerType;
import io.camunda.zeebe.protocol.record.value.AuthorizationRecordValue;
import io.camunda.zeebe.protocol.record.value.AuthorizationResourceType;
import io.camunda.zeebe.protocol.record.value.PermissionAction;
import java.util.List;

public final class AuthorizationRecord
extends UnifiedRecordValue
implements AuthorizationRecordValue {
    private final EnumProperty<PermissionAction> actionProp = new EnumProperty("action", PermissionAction.class);
    private final LongProperty ownerKeyProp = new LongProperty("ownerKey");
    private final EnumProperty<AuthorizationOwnerType> ownerTypeProp = new EnumProperty("ownerType", AuthorizationOwnerType.class, (Enum)AuthorizationOwnerType.UNSPECIFIED);
    private final EnumProperty<AuthorizationResourceType> resourceTypeProp = new EnumProperty("resourceType", AuthorizationResourceType.class);
    private final ArrayProperty<Permission> permissionsProp = new ArrayProperty("permissions", Permission::new);

    public AuthorizationRecord() {
        super(5);
        this.declareProperty((BaseProperty)this.actionProp).declareProperty(this.ownerTypeProp).declareProperty((BaseProperty)this.ownerKeyProp).declareProperty(this.resourceTypeProp).declareProperty(this.permissionsProp);
    }

    public void wrap(AuthorizationRecord record) {
        this.actionProp.setValue((Enum)record.getAction());
        this.ownerTypeProp.setValue((Enum)record.getOwnerType());
        this.ownerKeyProp.setValue(record.getOwnerKey().longValue());
        this.resourceTypeProp.setValue((Enum)record.getResourceType());
        record.getPermissions().forEach(this::addPermission);
    }

    public AuthorizationRecord copy() {
        AuthorizationRecord copy = new AuthorizationRecord();
        copy.actionProp.setValue((Enum)this.getAction());
        copy.ownerKeyProp.setValue(this.getOwnerKey().longValue());
        copy.ownerTypeProp.setValue((Enum)this.getOwnerType());
        copy.resourceTypeProp.setValue((Enum)this.getResourceType());
        this.getPermissions().forEach(copy::addPermission);
        return copy;
    }

    public PermissionAction getAction() {
        return (PermissionAction)this.actionProp.getValue();
    }

    public AuthorizationRecord setAction(PermissionAction action) {
        this.actionProp.setValue((Enum)action);
        return this;
    }

    public Long getOwnerKey() {
        return this.ownerKeyProp.getValue();
    }

    public AuthorizationRecord setOwnerKey(Long ownerKey) {
        this.ownerKeyProp.setValue(ownerKey.longValue());
        return this;
    }

    public AuthorizationOwnerType getOwnerType() {
        return (AuthorizationOwnerType)this.ownerTypeProp.getValue();
    }

    public AuthorizationRecord setOwnerType(AuthorizationOwnerType ownerType) {
        this.ownerTypeProp.setValue((Enum)ownerType);
        return this;
    }

    public AuthorizationResourceType getResourceType() {
        return (AuthorizationResourceType)this.resourceTypeProp.getValue();
    }

    public List<AuthorizationRecordValue.PermissionValue> getPermissions() {
        return this.permissionsProp.stream().map(permission -> {
            Permission copy = new Permission().copy((AuthorizationRecordValue.PermissionValue)permission);
            return copy;
        }).toList();
    }

    public AuthorizationRecord setResourceType(AuthorizationResourceType resourceType) {
        this.resourceTypeProp.setValue((Enum)resourceType);
        return this;
    }

    public AuthorizationRecord addPermission(AuthorizationRecordValue.PermissionValue permission) {
        ((Permission)this.permissionsProp.add()).copy(permission);
        return this;
    }
}

