/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.assertions;

import io.camunda.zeebe.client.api.response.PublishMessageResponse;
import io.camunda.zeebe.process.test.assertions.ProcessInstanceAssert;
import io.camunda.zeebe.process.test.filters.RecordStream;
import io.camunda.zeebe.process.test.filters.StreamFilter;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.MessageIntent;
import io.camunda.zeebe.protocol.record.intent.MessageStartEventSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.value.MessageStartEventSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessMessageSubscriptionRecordValue;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.ListAssert;

public class MessageAssert
extends AbstractAssert<MessageAssert, PublishMessageResponse> {
    private RecordStream recordStream;

    protected MessageAssert(PublishMessageResponse actual, RecordStream recordStream) {
        super((Object)actual, MessageAssert.class);
        this.recordStream = recordStream;
    }

    public MessageAssert hasBeenCorrelated() {
        boolean isCorrelated = StreamFilter.processMessageSubscription((RecordStream)this.recordStream).withMessageKey(((PublishMessageResponse)this.actual).getMessageKey()).withRejectionType(RejectionType.NULL_VAL).withIntent(ProcessMessageSubscriptionIntent.CORRELATED).stream().findFirst().isPresent();
        ((AbstractBooleanAssert)AssertionsForClassTypes.assertThat((boolean)isCorrelated).withFailMessage("Message with key %d was not correlated", new Object[]{((PublishMessageResponse)this.actual).getMessageKey()})).isTrue();
        return this;
    }

    public MessageAssert hasNotBeenCorrelated() {
        Optional<Record> recordOptional = StreamFilter.processMessageSubscription((RecordStream)this.recordStream).withMessageKey(((PublishMessageResponse)this.actual).getMessageKey()).withRejectionType(RejectionType.NULL_VAL).withIntent(ProcessMessageSubscriptionIntent.CORRELATED).stream().findFirst();
        ((AbstractBooleanAssert)AssertionsForClassTypes.assertThat((boolean)recordOptional.isPresent()).withFailMessage("Message with key %d was correlated to process instance %d", new Object[]{((PublishMessageResponse)this.actual).getMessageKey(), recordOptional.map(Record::getValue).map(ProcessMessageSubscriptionRecordValue::getProcessInstanceKey).orElse(-1L)})).isFalse();
        return this;
    }

    public MessageAssert hasCreatedProcessInstance() {
        boolean isCorrelated = StreamFilter.messageStartEventSubscription((RecordStream)this.recordStream).withMessageKey(((PublishMessageResponse)this.actual).getMessageKey()).withRejectionType(RejectionType.NULL_VAL).withIntent(MessageStartEventSubscriptionIntent.CORRELATED).stream().findFirst().isPresent();
        ((AbstractBooleanAssert)AssertionsForClassTypes.assertThat((boolean)isCorrelated).withFailMessage("Message with key %d did not lead to the creation of a process instance", new Object[]{((PublishMessageResponse)this.actual).getMessageKey()})).isTrue();
        return this;
    }

    public MessageAssert hasNotCreatedProcessInstance() {
        Optional<Record> recordOptional = StreamFilter.messageStartEventSubscription((RecordStream)this.recordStream).withMessageKey(((PublishMessageResponse)this.actual).getMessageKey()).withRejectionType(RejectionType.NULL_VAL).withIntent(MessageStartEventSubscriptionIntent.CORRELATED).stream().findFirst();
        ((AbstractBooleanAssert)AssertionsForClassTypes.assertThat((boolean)recordOptional.isPresent()).withFailMessage("Message with key %d was correlated to process instance %d", new Object[]{((PublishMessageResponse)this.actual).getMessageKey(), recordOptional.map(Record::getValue).map(MessageStartEventSubscriptionRecordValue::getProcessInstanceKey).orElse(-1L)})).isFalse();
        return this;
    }

    public MessageAssert hasExpired() {
        boolean isExpired = StreamFilter.message((RecordStream)this.recordStream).withKey(((PublishMessageResponse)this.actual).getMessageKey()).withRejectionType(RejectionType.NULL_VAL).withIntent(MessageIntent.EXPIRED).stream().findFirst().isPresent();
        ((AbstractBooleanAssert)AssertionsForClassTypes.assertThat((boolean)isExpired).withFailMessage("Message with key %d has not expired", new Object[]{((PublishMessageResponse)this.actual).getMessageKey()})).isTrue();
        return this;
    }

    public MessageAssert hasNotExpired() {
        boolean isExpired = StreamFilter.message((RecordStream)this.recordStream).withKey(((PublishMessageResponse)this.actual).getMessageKey()).withRejectionType(RejectionType.NULL_VAL).withIntent(MessageIntent.EXPIRED).stream().findFirst().isPresent();
        ((AbstractBooleanAssert)AssertionsForClassTypes.assertThat((boolean)isExpired).withFailMessage("Message with key %d has expired", new Object[]{((PublishMessageResponse)this.actual).getMessageKey()})).isFalse();
        return this;
    }

    public ProcessInstanceAssert extractingProcessInstance() {
        List<Long> correlatedProcessInstances = this.getProcessInstanceKeysForCorrelatedMessage();
        correlatedProcessInstances.addAll(this.getProcessInstanceKeysForCorrelatedMessageStartEvent());
        ((ListAssert)Assertions.assertThat(correlatedProcessInstances).withFailMessage("Expected to find one correlated process instance for message key %d but found %d: %s", new Object[]{((PublishMessageResponse)this.actual).getMessageKey(), correlatedProcessInstances.size(), correlatedProcessInstances})).hasSize(1);
        return new ProcessInstanceAssert(correlatedProcessInstances.get(0), this.recordStream);
    }

    private List<Long> getProcessInstanceKeysForCorrelatedMessage() {
        return StreamFilter.processMessageSubscription((RecordStream)this.recordStream).withMessageKey(((PublishMessageResponse)this.actual).getMessageKey()).withRejectionType(RejectionType.NULL_VAL).withIntent(ProcessMessageSubscriptionIntent.CORRELATED).stream().map(record -> ((ProcessMessageSubscriptionRecordValue)record.getValue()).getProcessInstanceKey()).collect(Collectors.toList());
    }

    private List<Long> getProcessInstanceKeysForCorrelatedMessageStartEvent() {
        return StreamFilter.messageStartEventSubscription((RecordStream)this.recordStream).withMessageKey(((PublishMessageResponse)this.actual).getMessageKey()).withRejectionType(RejectionType.NULL_VAL).withIntent(MessageStartEventSubscriptionIntent.CORRELATED).stream().map(record -> ((MessageStartEventSubscriptionRecordValue)record.getValue()).getProcessInstanceKey()).collect(Collectors.toList());
    }
}

