/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.msgpack.value;

import io.camunda.zeebe.msgpack.spec.MsgPackReader;
import io.camunda.zeebe.msgpack.spec.MsgPackWriter;
import io.camunda.zeebe.msgpack.value.BaseValue;
import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class PackedValue
extends BaseValue {
    private final DirectBuffer buffer = new UnsafeBuffer(0L, 0);
    private int length;

    public PackedValue() {
    }

    public PackedValue(DirectBuffer defaultValue, int offset, int length) {
        this.wrap(defaultValue, offset, length);
    }

    public void wrap(DirectBuffer buff, int offset, int length) {
        this.buffer.wrap(buff, offset, length);
        this.length = length;
    }

    public DirectBuffer getValue() {
        return this.buffer;
    }

    @Override
    public void reset() {
        this.buffer.wrap(0L, 0);
        this.length = 0;
    }

    @Override
    public void writeJSON(StringBuilder builder) {
        builder.append("[packed value (length=");
        builder.append(this.length);
        builder.append(")]");
    }

    @Override
    public void write(MsgPackWriter writer) {
        writer.writeRaw(this.buffer);
    }

    @Override
    public void read(MsgPackReader reader) {
        DirectBuffer buffer = reader.getBuffer();
        int offset = reader.getOffset();
        reader.skipValue();
        int lenght = reader.getOffset() - offset;
        this.wrap(buffer, offset, lenght);
    }

    @Override
    public int getEncodedLength() {
        return this.length;
    }

    public int hashCode() {
        return Objects.hash(this.buffer, this.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PackedValue)) {
            return false;
        }
        PackedValue that = (PackedValue)o;
        return this.length == that.length && Objects.equals(this.buffer, that.buffer);
    }
}

