/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.broker.request;

import io.camunda.zeebe.broker.client.api.dto.BrokerExecuteCommand;
import io.camunda.zeebe.protocol.impl.record.value.authorization.AuthorizationRecord;
import io.camunda.zeebe.protocol.impl.record.value.authorization.Permission;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.AuthorizationIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.value.AuthorizationRecordValue;
import io.camunda.zeebe.protocol.record.value.AuthorizationResourceType;
import io.camunda.zeebe.protocol.record.value.PermissionAction;
import io.camunda.zeebe.protocol.record.value.PermissionType;
import java.util.List;
import org.agrona.DirectBuffer;

public class BrokerAuthorizationPatchRequest
extends BrokerExecuteCommand<AuthorizationRecord> {
    private final AuthorizationRecord requestDto = new AuthorizationRecord();

    public BrokerAuthorizationPatchRequest() {
        super(ValueType.AUTHORIZATION, (Intent)AuthorizationIntent.ADD_PERMISSION);
    }

    public BrokerAuthorizationPatchRequest setOwnerKey(Long ownerKey) {
        this.requestDto.setOwnerKey(ownerKey);
        return this;
    }

    public BrokerAuthorizationPatchRequest setAction(PermissionAction action) {
        this.requestDto.setAction(action);
        return this;
    }

    public BrokerAuthorizationPatchRequest setResourceType(AuthorizationResourceType resourceType) {
        this.requestDto.setResourceType(resourceType);
        return this;
    }

    public BrokerAuthorizationPatchRequest addPermissions(PermissionType permissionType, List<String> resourceIds) {
        this.requestDto.addPermission((AuthorizationRecordValue.PermissionValue)new Permission().setPermissionType(permissionType).addResourceIds(resourceIds));
        return this;
    }

    public AuthorizationRecord getRequestWriter() {
        return this.requestDto;
    }

    protected AuthorizationRecord toResponseDto(DirectBuffer buffer) {
        AuthorizationRecord response = new AuthorizationRecord();
        response.wrap(buffer);
        return response;
    }
}

