/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.broker;

import io.camunda.zeebe.broker.client.api.BrokerClusterState;
import io.camunda.zeebe.broker.client.api.BrokerTopologyManager;
import io.camunda.zeebe.broker.client.api.NoTopologyAvailableException;
import io.camunda.zeebe.broker.client.api.RequestDispatchStrategy;
import io.camunda.zeebe.dynamic.config.state.RoutingState;
import io.camunda.zeebe.protocol.impl.SubscriptionUtil;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import org.agrona.DirectBuffer;

public final class PublishMessageDispatchStrategy
implements RequestDispatchStrategy {
    private final String correlationKey;

    public PublishMessageDispatchStrategy(String correlationKey) {
        this.correlationKey = correlationKey;
    }

    public int determinePartition(BrokerTopologyManager topologyManager) {
        return topologyManager.getClusterConfiguration().routingState().map(this::fromRoutingState).or(() -> Optional.ofNullable(topologyManager.getTopology()).map(this::fromTopology)).orElseThrow(() -> new NoTopologyAvailableException("Expected to pick partition for message with correlation key '%s', but no topology is available".formatted(this.correlationKey)));
    }

    public int fromRoutingState(RoutingState routingState) {
        int partitionCount;
        RoutingState.MessageCorrelation messageCorrelation = routingState.messageCorrelation();
        Objects.requireNonNull(messageCorrelation);
        RoutingState.MessageCorrelation messageCorrelation2 = messageCorrelation;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RoutingState.MessageCorrelation.HashMod.class}, (Object)messageCorrelation2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: 
        }
        RoutingState.MessageCorrelation.HashMod hashMod = (RoutingState.MessageCorrelation.HashMod)messageCorrelation2;
        try {
            int n2;
            partitionCount = n2 = hashMod.partitionCount();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return SubscriptionUtil.getSubscriptionPartitionId((DirectBuffer)BufferUtil.wrapString((String)this.correlationKey), (int)partitionCount);
    }

    public int fromTopology(BrokerClusterState topology) {
        int partitionCount = topology.getPartitionsCount();
        if (partitionCount == 0) {
            throw new NoTopologyAvailableException("Expected to pick partition for message with correlation key '%s', but topology contains no partitions".formatted(this.correlationKey));
        }
        return SubscriptionUtil.getSubscriptionPartitionId((DirectBuffer)BufferUtil.wrapString((String)this.correlationKey), (int)partitionCount);
    }
}

