/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.zeebe.client.protocol.rest.AuthorizationPatchRequestPermissionsInner;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"action", "resourceType", "permissions"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AuthorizationPatchRequest {
    public static final String JSON_PROPERTY_ACTION = "action";
    private ActionEnum action;
    public static final String JSON_PROPERTY_RESOURCE_TYPE = "resourceType";
    private ResourceTypeEnum resourceType;
    public static final String JSON_PROPERTY_PERMISSIONS = "permissions";
    private List<AuthorizationPatchRequestPermissionsInner> permissions = new ArrayList<AuthorizationPatchRequestPermissionsInner>();

    public AuthorizationPatchRequest action(ActionEnum action) {
        this.action = action;
        return this;
    }

    @Nullable
    @JsonProperty(value="action")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ActionEnum getAction() {
        return this.action;
    }

    @JsonProperty(value="action")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAction(ActionEnum action) {
        this.action = action;
    }

    public AuthorizationPatchRequest resourceType(ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @Nullable
    @JsonProperty(value="resourceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResourceTypeEnum getResourceType() {
        return this.resourceType;
    }

    @JsonProperty(value="resourceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResourceType(ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
    }

    public AuthorizationPatchRequest permissions(List<AuthorizationPatchRequestPermissionsInner> permissions) {
        this.permissions = permissions;
        return this;
    }

    public AuthorizationPatchRequest addPermissionsItem(AuthorizationPatchRequestPermissionsInner permissionsItem) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<AuthorizationPatchRequestPermissionsInner>();
        }
        this.permissions.add(permissionsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="permissions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AuthorizationPatchRequestPermissionsInner> getPermissions() {
        return this.permissions;
    }

    @JsonProperty(value="permissions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPermissions(List<AuthorizationPatchRequestPermissionsInner> permissions) {
        this.permissions = permissions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizationPatchRequest authorizationPatchRequest = (AuthorizationPatchRequest)o;
        return Objects.equals((Object)this.action, (Object)authorizationPatchRequest.action) && Objects.equals((Object)this.resourceType, (Object)authorizationPatchRequest.resourceType) && Objects.equals(this.permissions, authorizationPatchRequest.permissions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.resourceType, this.permissions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthorizationPatchRequest {\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    resourceType: ").append(this.toIndentedString((Object)this.resourceType)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getAction() != null) {
            try {
                joiner.add(String.format("%saction%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getAction()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getResourceType() != null) {
            try {
                joiner.add(String.format("%sresourceType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getResourceType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getPermissions() != null) {
            for (int i = 0; i < this.getPermissions().size(); ++i) {
                if (this.getPermissions().get(i) == null) continue;
                joiner.add(this.getPermissions().get(i).toUrlQueryString(String.format("%spermissions%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }

    public static enum ActionEnum {
        ADD("ADD"),
        REMOVE("REMOVE"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private ActionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ActionEnum fromValue(String value) {
            for (ActionEnum b : ActionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum ResourceTypeEnum {
        AUTHORIZATION("AUTHORIZATION"),
        MESSAGE("MESSAGE"),
        JOB("JOB"),
        APPLICATION("APPLICATION"),
        TENANT("TENANT"),
        DEPLOYMENT("DEPLOYMENT"),
        PROCESS_DEFINITION("PROCESS_DEFINITION"),
        USER_TASK("USER_TASK"),
        DECISION_REQUIREMENTS_DEFINITION("DECISION_REQUIREMENTS_DEFINITION"),
        DECISION_DEFINITION("DECISION_DEFINITION"),
        USER_GROUP("USER_GROUP"),
        USER("USER"),
        ROLE("ROLE"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private ResourceTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResourceTypeEnum fromValue(String value) {
            for (ResourceTypeEnum b : ResourceTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

