/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.response.EvaluateDecisionResponse;
import io.camunda.zeebe.client.api.response.EvaluatedDecision;
import io.camunda.zeebe.client.impl.response.EvaluatedDecisionImpl;
import io.camunda.zeebe.client.protocol.rest.EvaluatedDecisionItem;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class EvaluateDecisionResponseImpl
implements EvaluateDecisionResponse {
    @JsonIgnore
    private final JsonMapper jsonMapper;
    private final String decisionId;
    private final long decisionKey;
    private final int decisionVersion;
    private final String decisionName;
    private final String decisionRequirementsId;
    private final long decisionRequirementsKey;
    private final String decisionOutput;
    private final List<EvaluatedDecision> evaluatedDecisions = new ArrayList<EvaluatedDecision>();
    private final String failedDecisionId;
    private final String failureMessage;
    private final String tenantId;
    private final long decisionInstanceKey;

    public EvaluateDecisionResponseImpl(io.camunda.zeebe.client.protocol.rest.EvaluateDecisionResponse response, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.decisionId = response.getDecisionDefinitionId();
        this.decisionKey = response.getDecisionDefinitionKey();
        this.decisionVersion = response.getDecisionDefinitionVersion();
        this.decisionName = response.getDecisionDefinitionName();
        this.decisionRequirementsId = response.getDecisionRequirementsId();
        this.decisionRequirementsKey = response.getDecisionRequirementsKey();
        this.decisionOutput = response.getOutput();
        this.failedDecisionId = response.getFailedDecisionDefinitionId();
        this.failureMessage = response.getFailureMessage();
        this.tenantId = response.getTenantId();
        this.decisionInstanceKey = response.getDecisionInstanceKey();
        this.buildEvaluatedDecisions(response);
    }

    public EvaluateDecisionResponseImpl(JsonMapper jsonMapper, GatewayOuterClass.EvaluateDecisionResponse response) {
        this.jsonMapper = jsonMapper;
        this.decisionId = response.getDecisionId();
        this.decisionKey = response.getDecisionKey();
        this.decisionVersion = response.getDecisionVersion();
        this.decisionName = response.getDecisionName();
        this.decisionRequirementsId = response.getDecisionRequirementsId();
        this.decisionRequirementsKey = response.getDecisionRequirementsKey();
        this.decisionOutput = response.getDecisionOutput();
        this.failedDecisionId = response.getFailedDecisionId();
        this.failureMessage = response.getFailureMessage();
        this.tenantId = response.getTenantId();
        this.decisionInstanceKey = response.getDecisionInstanceKey();
        response.getEvaluatedDecisionsList().stream().map(evaluatedDecision -> new EvaluatedDecisionImpl(jsonMapper, (GatewayOuterClass.EvaluatedDecision)evaluatedDecision)).forEach(this.evaluatedDecisions::add);
    }

    private void buildEvaluatedDecisions(io.camunda.zeebe.client.protocol.rest.EvaluateDecisionResponse response) {
        if (response.getEvaluatedDecisions() == null) {
            return;
        }
        this.evaluatedDecisions.addAll(response.getEvaluatedDecisions().stream().map(decision -> new EvaluatedDecisionImpl((EvaluatedDecisionItem)decision, this.jsonMapper)).collect(Collectors.toList()));
    }

    @Override
    public String getDecisionId() {
        return this.decisionId;
    }

    @Override
    public int getDecisionVersion() {
        return this.decisionVersion;
    }

    @Override
    public long getDecisionKey() {
        return this.decisionKey;
    }

    @Override
    public String getDecisionName() {
        return this.decisionName;
    }

    @Override
    public String getDecisionRequirementsId() {
        return this.decisionRequirementsId;
    }

    @Override
    public long getDecisionRequirementsKey() {
        return this.decisionRequirementsKey;
    }

    @Override
    public String getDecisionOutput() {
        return this.decisionOutput;
    }

    @Override
    public List<EvaluatedDecision> getEvaluatedDecisions() {
        return this.evaluatedDecisions;
    }

    @Override
    public String getFailedDecisionId() {
        return this.failedDecisionId;
    }

    @Override
    public String getFailureMessage() {
        return this.failureMessage;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public long getDecisionInstanceKey() {
        return this.decisionInstanceKey;
    }
}

