/*
 * Camunda 8 REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.zeebe.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * IncidentItem
 * @deprecated
 */
@Deprecated
@JsonPropertyOrder({
  IncidentItem.JSON_PROPERTY_KEY,
  IncidentItem.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  IncidentItem.JSON_PROPERTY_PROCESS_INSTANCE_KEY,
  IncidentItem.JSON_PROPERTY_FLOW_NODE_INSTANCE_KEY,
  IncidentItem.JSON_PROPERTY_JOB_KEY,
  IncidentItem.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  IncidentItem.JSON_PROPERTY_ERROR_TYPE,
  IncidentItem.JSON_PROPERTY_ERROR_MESSAGE,
  IncidentItem.JSON_PROPERTY_FLOW_NODE_ID,
  IncidentItem.JSON_PROPERTY_CREATION_TIME,
  IncidentItem.JSON_PROPERTY_STATE,
  IncidentItem.JSON_PROPERTY_TREE_PATH,
  IncidentItem.JSON_PROPERTY_TENANT_ID
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-04-01T08:58:27.371823074Z[GMT]", comments = "Generator version: 7.8.0")
public class IncidentItem {
  public static final String JSON_PROPERTY_KEY = "key";
  private Long key;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  private Long processDefinitionKey;

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_KEY = "processInstanceKey";
  private Long processInstanceKey;

  public static final String JSON_PROPERTY_FLOW_NODE_INSTANCE_KEY = "flowNodeInstanceKey";
  private Long flowNodeInstanceKey;

  public static final String JSON_PROPERTY_JOB_KEY = "jobKey";
  private Long jobKey;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  private String processDefinitionId;

  /**
   * Incident error type with a defined set of values.
   */
  public enum ErrorTypeEnum {
    UNSPECIFIED("UNSPECIFIED"),
    
    UNKNOWN("UNKNOWN"),
    
    IO_MAPPING_ERROR("IO_MAPPING_ERROR"),
    
    JOB_NO_RETRIES("JOB_NO_RETRIES"),
    
    CONDITION_ERROR("CONDITION_ERROR"),
    
    EXTRACT_VALUE_ERROR("EXTRACT_VALUE_ERROR"),
    
    CALLED_ELEMENT_ERROR("CALLED_ELEMENT_ERROR"),
    
    UNHANDLED_ERROR_EVENT("UNHANDLED_ERROR_EVENT"),
    
    MESSAGE_SIZE_EXCEEDED("MESSAGE_SIZE_EXCEEDED"),
    
    CALLED_DECISION_ERROR("CALLED_DECISION_ERROR"),
    
    DECISION_EVALUATION_ERROR("DECISION_EVALUATION_ERROR"),
    
    FORM_NOT_FOUND("FORM_NOT_FOUND"),
    
    RESOURCE_NOT_FOUND("RESOURCE_NOT_FOUND"),
    
    EXECUTION_LISTENER_NO_RETRIES("EXECUTION_LISTENER_NO_RETRIES"),
    
    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    ErrorTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ErrorTypeEnum fromValue(String value) {
      for (ErrorTypeEnum b : ErrorTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return UNKNOWN_DEFAULT_OPEN_API;
    }
  }

  public static final String JSON_PROPERTY_ERROR_TYPE = "errorType";
  private ErrorTypeEnum errorType;

  public static final String JSON_PROPERTY_ERROR_MESSAGE = "errorMessage";
  private String errorMessage;

  public static final String JSON_PROPERTY_FLOW_NODE_ID = "flowNodeId";
  private String flowNodeId;

  public static final String JSON_PROPERTY_CREATION_TIME = "creationTime";
  private String creationTime;

  /**
   * State of this incident with a defined set of values.
   */
  public enum StateEnum {
    ACTIVE("ACTIVE"),
    
    MIGRATED("MIGRATED"),
    
    RESOLVED("RESOLVED"),
    
    PENDING("PENDING"),
    
    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    StateEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StateEnum fromValue(String value) {
      for (StateEnum b : StateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return UNKNOWN_DEFAULT_OPEN_API;
    }
  }

  public static final String JSON_PROPERTY_STATE = "state";
  private StateEnum state;

  public static final String JSON_PROPERTY_TREE_PATH = "treePath";
  private String treePath;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  private String tenantId;

  public IncidentItem() {
  }

  public IncidentItem key(Long key) {
    
    this.key = key;
    return this;
  }

  /**
   * The assigned key, which acts as a unique identifier for this incident.
   * @return key
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getKey() {
    return key;
  }


  @JsonProperty(JSON_PROPERTY_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setKey(Long key) {
    this.key = key;
  }

  public IncidentItem processDefinitionKey(Long processDefinitionKey) {
    
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * The process definition key associated to this incident.
   * @return processDefinitionKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getProcessDefinitionKey() {
    return processDefinitionKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionKey(Long processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public IncidentItem processInstanceKey(Long processInstanceKey) {
    
    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * The process instance key associated to this incident.
   * @return processInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getProcessInstanceKey() {
    return processInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessInstanceKey(Long processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  public IncidentItem flowNodeInstanceKey(Long flowNodeInstanceKey) {
    
    this.flowNodeInstanceKey = flowNodeInstanceKey;
    return this;
  }

  /**
   * The flow node instance key associated to this incident.
   * @return flowNodeInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FLOW_NODE_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getFlowNodeInstanceKey() {
    return flowNodeInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_FLOW_NODE_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFlowNodeInstanceKey(Long flowNodeInstanceKey) {
    this.flowNodeInstanceKey = flowNodeInstanceKey;
  }

  public IncidentItem jobKey(Long jobKey) {
    
    this.jobKey = jobKey;
    return this;
  }

  /**
   * The job key, if exists, associated with this incident.
   * @return jobKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_JOB_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getJobKey() {
    return jobKey;
  }


  @JsonProperty(JSON_PROPERTY_JOB_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setJobKey(Long jobKey) {
    this.jobKey = jobKey;
  }

  public IncidentItem processDefinitionId(String processDefinitionId) {
    
    this.processDefinitionId = processDefinitionId;
    return this;
  }

  /**
   * The bpmn process id associated to this incident.
   * @return processDefinitionId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessDefinitionId() {
    return processDefinitionId;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public IncidentItem errorType(ErrorTypeEnum errorType) {
    
    this.errorType = errorType;
    return this;
  }

  /**
   * Incident error type with a defined set of values.
   * @return errorType
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ERROR_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ErrorTypeEnum getErrorType() {
    return errorType;
  }


  @JsonProperty(JSON_PROPERTY_ERROR_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorType(ErrorTypeEnum errorType) {
    this.errorType = errorType;
  }

  public IncidentItem errorMessage(String errorMessage) {
    
    this.errorMessage = errorMessage;
    return this;
  }

  /**
   * Error message which describes the error in more detail.
   * @return errorMessage
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ERROR_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getErrorMessage() {
    return errorMessage;
  }


  @JsonProperty(JSON_PROPERTY_ERROR_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
  }

  public IncidentItem flowNodeId(String flowNodeId) {
    
    this.flowNodeId = flowNodeId;
    return this;
  }

  /**
   * The flow node id associated to this incident.
   * @return flowNodeId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FLOW_NODE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFlowNodeId() {
    return flowNodeId;
  }


  @JsonProperty(JSON_PROPERTY_FLOW_NODE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFlowNodeId(String flowNodeId) {
    this.flowNodeId = flowNodeId;
  }

  public IncidentItem creationTime(String creationTime) {
    
    this.creationTime = creationTime;
    return this;
  }

  /**
   * Date of incident creation.
   * @return creationTime
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CREATION_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCreationTime() {
    return creationTime;
  }


  @JsonProperty(JSON_PROPERTY_CREATION_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreationTime(String creationTime) {
    this.creationTime = creationTime;
  }

  public IncidentItem state(StateEnum state) {
    
    this.state = state;
    return this;
  }

  /**
   * State of this incident with a defined set of values.
   * @return state
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StateEnum getState() {
    return state;
  }


  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(StateEnum state) {
    this.state = state;
  }

  public IncidentItem treePath(String treePath) {
    
    this.treePath = treePath;
    return this;
  }

  /**
   * The path from process instance via flow node ids and flow node instance keys leading to this incident.
   * @return treePath
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TREE_PATH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTreePath() {
    return treePath;
  }


  @JsonProperty(JSON_PROPERTY_TREE_PATH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTreePath(String treePath) {
    this.treePath = treePath;
  }

  public IncidentItem tenantId(String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant id of the incident.
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTenantId() {
    return tenantId;
  }


  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IncidentItem incidentItem = (IncidentItem) o;
    return Objects.equals(this.key, incidentItem.key) &&
        Objects.equals(this.processDefinitionKey, incidentItem.processDefinitionKey) &&
        Objects.equals(this.processInstanceKey, incidentItem.processInstanceKey) &&
        Objects.equals(this.flowNodeInstanceKey, incidentItem.flowNodeInstanceKey) &&
        Objects.equals(this.jobKey, incidentItem.jobKey) &&
        Objects.equals(this.processDefinitionId, incidentItem.processDefinitionId) &&
        Objects.equals(this.errorType, incidentItem.errorType) &&
        Objects.equals(this.errorMessage, incidentItem.errorMessage) &&
        Objects.equals(this.flowNodeId, incidentItem.flowNodeId) &&
        Objects.equals(this.creationTime, incidentItem.creationTime) &&
        Objects.equals(this.state, incidentItem.state) &&
        Objects.equals(this.treePath, incidentItem.treePath) &&
        Objects.equals(this.tenantId, incidentItem.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, processDefinitionKey, processInstanceKey, flowNodeInstanceKey, jobKey, processDefinitionId, errorType, errorMessage, flowNodeId, creationTime, state, treePath, tenantId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IncidentItem {\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("    flowNodeInstanceKey: ").append(toIndentedString(flowNodeInstanceKey)).append("\n");
    sb.append("    jobKey: ").append(toIndentedString(jobKey)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    errorType: ").append(toIndentedString(errorType)).append("\n");
    sb.append("    errorMessage: ").append(toIndentedString(errorMessage)).append("\n");
    sb.append("    flowNodeId: ").append(toIndentedString(flowNodeId)).append("\n");
    sb.append("    creationTime: ").append(toIndentedString(creationTime)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    treePath: ").append(toIndentedString(treePath)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `errorType` to the URL query string
    if (getErrorType() != null) {
      try {
        joiner.add(String.format("%serrorType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getErrorType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `errorMessage` to the URL query string
    if (getErrorMessage() != null) {
      try {
        joiner.add(String.format("%serrorMessage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getErrorMessage()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `flowNodeId` to the URL query string
    if (getFlowNodeId() != null) {
      try {
        joiner.add(String.format("%sflowNodeId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFlowNodeId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `creationTime` to the URL query string
    if (getCreationTime() != null) {
      try {
        joiner.add(String.format("%screationTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCreationTime()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `state` to the URL query string
    if (getState() != null) {
      try {
        joiner.add(String.format("%sstate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getState()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `treePath` to the URL query string
    if (getTreePath() != null) {
      try {
        joiner.add(String.format("%streePath%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTreePath()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

