/*
 * Camunda 8 REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.zeebe.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * A deployed form.
 * @deprecated
 */
@Deprecated
@JsonPropertyOrder({
  DeploymentForm.JSON_PROPERTY_FORM_KEY,
  DeploymentForm.JSON_PROPERTY_FORM_ID,
  DeploymentForm.JSON_PROPERTY_VERSION,
  DeploymentForm.JSON_PROPERTY_RESOURCE_NAME,
  DeploymentForm.JSON_PROPERTY_TENANT_ID
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-04-01T08:58:27.371823074Z[GMT]", comments = "Generator version: 7.8.0")
public class DeploymentForm {
  public static final String JSON_PROPERTY_FORM_KEY = "formKey";
  private Long formKey;

  public static final String JSON_PROPERTY_FORM_ID = "formId";
  private String formId;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Integer version;

  public static final String JSON_PROPERTY_RESOURCE_NAME = "resourceName";
  private String resourceName;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  private String tenantId;

  public DeploymentForm() {
  }

  public DeploymentForm formKey(Long formKey) {
    
    this.formKey = formKey;
    return this;
  }

  /**
   * The assigned key, which acts as a unique identifier for this form.
   * @return formKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FORM_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getFormKey() {
    return formKey;
  }


  @JsonProperty(JSON_PROPERTY_FORM_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFormKey(Long formKey) {
    this.formKey = formKey;
  }

  public DeploymentForm formId(String formId) {
    
    this.formId = formId;
    return this;
  }

  /**
   * The form ID, as parsed during deployment, together with the version forms a unique identifier for a specific form. 
   * @return formId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FORM_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFormId() {
    return formId;
  }


  @JsonProperty(JSON_PROPERTY_FORM_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFormId(String formId) {
    this.formId = formId;
  }

  public DeploymentForm version(Integer version) {
    
    this.version = version;
    return this;
  }

  /**
   * The assigned form version.
   * @return version
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getVersion() {
    return version;
  }


  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(Integer version) {
    this.version = version;
  }

  public DeploymentForm resourceName(String resourceName) {
    
    this.resourceName = resourceName;
    return this;
  }

  /**
   * The resource name from which this form was parsed.
   * @return resourceName
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RESOURCE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getResourceName() {
    return resourceName;
  }


  @JsonProperty(JSON_PROPERTY_RESOURCE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResourceName(String resourceName) {
    this.resourceName = resourceName;
  }

  public DeploymentForm tenantId(String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of the deployed form.
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTenantId() {
    return tenantId;
  }


  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeploymentForm deploymentForm = (DeploymentForm) o;
    return Objects.equals(this.formKey, deploymentForm.formKey) &&
        Objects.equals(this.formId, deploymentForm.formId) &&
        Objects.equals(this.version, deploymentForm.version) &&
        Objects.equals(this.resourceName, deploymentForm.resourceName) &&
        Objects.equals(this.tenantId, deploymentForm.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(formKey, formId, version, resourceName, tenantId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeploymentForm {\n");
    sb.append("    formKey: ").append(toIndentedString(formKey)).append("\n");
    sb.append("    formId: ").append(toIndentedString(formId)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    resourceName: ").append(toIndentedString(resourceName)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `formId` to the URL query string
    if (getFormId() != null) {
      try {
        joiner.add(String.format("%sformId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFormId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `version` to the URL query string
    if (getVersion() != null) {
      try {
        joiner.add(String.format("%sversion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVersion()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `resourceName` to the URL query string
    if (getResourceName() != null) {
      try {
        joiner.add(String.format("%sresourceName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getResourceName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

