/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.AddPermissionsCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.AddPermissionsResponse;
import io.camunda.zeebe.client.impl.command.ArgumentUtil;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.protocol.rest.AuthorizationPatchRequest;
import io.camunda.zeebe.client.protocol.rest.AuthorizationPatchRequestPermissionsInner;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class AddPermissionsCommandImpl
implements AddPermissionsCommandStep1,
AddPermissionsCommandStep1.AddPermissionsCommandStep2,
AddPermissionsCommandStep1.AddPermissionsCommandStep3,
AddPermissionsCommandStep1.AddPermissionsCommandStep4 {
    private final String path;
    private final AuthorizationPatchRequest request;
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private AuthorizationPatchRequestPermissionsInner currentPermission;

    public AddPermissionsCommandImpl(long ownerKey, HttpClient httpClient, JsonMapper jsonMapper) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.request = new AuthorizationPatchRequest().action(AuthorizationPatchRequest.ActionEnum.ADD);
        this.path = "/authorizations/" + ownerKey;
    }

    @Override
    public AddPermissionsCommandStep1.AddPermissionsCommandStep2 resourceType(AuthorizationPatchRequest.ResourceTypeEnum resourceType) {
        ArgumentUtil.ensureNotNull("resourceType", (Object)resourceType);
        this.request.resourceType(resourceType);
        return this;
    }

    @Override
    public AddPermissionsCommandStep1.AddPermissionsCommandStep3 permission(AuthorizationPatchRequestPermissionsInner.PermissionTypeEnum permissionType) {
        ArgumentUtil.ensureNotNull("permissionType", (Object)permissionType);
        this.currentPermission = new AuthorizationPatchRequestPermissionsInner();
        this.currentPermission.permissionType(permissionType);
        this.request.addPermissionsItem(this.currentPermission);
        return this;
    }

    @Override
    public AddPermissionsCommandStep1.AddPermissionsCommandStep4 resourceIds(List<String> resourceIds) {
        ArgumentUtil.ensureNotNullOrEmpty("resourceIds", resourceIds);
        resourceIds.forEach(this::resourceId);
        return this;
    }

    @Override
    public AddPermissionsCommandStep1.AddPermissionsCommandStep4 resourceId(String resourceId) {
        ArgumentUtil.ensureNotNullNorEmpty("resourceId", resourceId);
        this.currentPermission.addResourceIdsItem(resourceId);
        return this;
    }

    @Override
    public FinalCommandStep<AddPermissionsResponse> requestTimeout(Duration requestTimeout) {
        ArgumentUtil.ensurePositive("requestTimeout", requestTimeout);
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<AddPermissionsResponse> send() {
        HttpZeebeFuture<AddPermissionsResponse> result = new HttpZeebeFuture<AddPermissionsResponse>();
        this.httpClient.post(this.path, this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), result);
        return result;
    }
}

